# LayerDAG

## Dependencies

To set up the environment for running the code, follow the instructions below.

```bash
conda create -n LayerDAG python=3.10 -y
conda activate LayerDAG
pip install tqdm
pip install torch==1.12.0+cu116 --extra-index-url https://download.pytorch.org/whl/cu116
conda install -c conda-forge cudatoolkit=11.6
conda clean --all
pip install dgl==1.1.0+cu116 -f https://data.dgl.ai/wheels/cu116/repo.html
pip install einops
pip install wandb
pip install pydantic
pip install pandas
pip install pyemd
```

## Tpu Tile

The TpuGraphs dataset is released at https://github.com/google-research-datasets/tpu_graphs/tree/main under the license of Apache-2.0. We adapt the tile collection of the dataset by averaging the normalized runtimes acorss compiler configurations. The pre-processed data files and the original data license are available in `data_files/`.

### Training

```bash
python train.py --config_file configs/tpu_tile.yaml
```

The trained model will be saved to a file with the name `model_tpu_tile_XXX.pth`, where `XXX` is the timestamp.

### Sampling

```bash
python sample.py --model_path Y
```

where `Y` is the path to a trained model checkpoint. To use a non-constant number of denoising steps, set `--min_num_steps_n`, `--max_num_steps_n`, `--min_num_steps_e`, `--max_num_steps_e` respectively for the minimum and maximum number of steps for node and edge denoising.

## Troubleshooting

**An error occurs that the program cannot find `libcusparse.so`.**

To search for the location of it on linux,

```bash
find /path/to/directory -name libcusparse.so.11 -exec realpath {} \;
```

where `/path/to/directory` is the directory you want to search. Assume that the search returns `home/miniconda3/envs/LayerDAG/lib/libcusparse.so.11`. Then you need to manually specify the environment variable as follows.

```bash
export LD_LIBRARY_PATH=home/miniconda3/envs/LayerDAG/lib:$LD_LIBRARY_PATH
```
