TS=$(date "+%Y%0m%0d_%T")

project_root_path="../"
cli_path="${project_root_path}/src/benchmark_evaluation/mmlu_eval.py"
data_path="${project_root_path}/data/MMLU"

### Exps with Llama2-7B
# model_name="/mnt/llms/model/meta-llama/Llama-2-13b-hf"
# model_name="/mnt/llms/model/meta-llama/Llama-3-8b-hf"
# model_name="/mnt/llms/model/google-gemma/gemma-2b"
# model_name="/mnt/llms/model/google-gemma/gemma-7b"
# model_name="/mnt/llms/model/gpt/gpt2-xl"
# model_name="/mnt/llms/model/mistral/mistral-7B-v0.1"
model_name="/mnt/llms/model/meta-llama/Llama-2-7b-hf"

### Baseline
# output_path="${project_root_path}/exp_results/mmlu/${TS}/baseline_mistral_7B"
output_path="${project_root_path}/exp_results/bbh/${TS}/baseline_llama2_13b"
mkdir -p $output_path
cp $0 "$(dirname "$output_path")"

generation_args="
    --relative_top 0.0
"

echo "Greedy Decoding"
CMD="CUDA_VISIBLE_DEVICES=5 python ${cli_path}
    --model-name ${model_name} \
    --data-path ${data_path} \
    --max-token 4096 \
    --num-gpus 2 \
    --mode cot-enhance \
    --prompt-num 0
    "
    # --bias \
echo $CMD
eval $CMD
wait
