# AutoDock-GPU implementation in the DGAPN framework

Our pipeline achieves high-throughput processing by taking advantage of the performance benefits of  [AutoDock-GPU](https://doi.org/10.26434/chemrxiv.9702389.v1) for structure-based molecular docking and calculation of the binding affinity of the putative protein-ligand complexes generated. The implementation in the DGAPN framework is done in two steps:

#### 1.  Receptor pre-processing

#### 2.  Reward scores from molecular docking within DGAPN


## Installation

#### 1.  Install the software for receptor pre-processing:

-   AutoDockTools (http://autodock.scripps.edu/resources/adt)

-   AutoGrid4 (http://autodock.scripps.edu/wiki/AutoGrid)

#### 2.  Install the software for molecular docking on Linux compute server
    > along with DGAPN

-   RDKit (https://www.rdkit.org/)

-   Open Babel (https://open-babel.readthedocs.io/en/latest/Command-line_tools/babel.html)

-   AutoDock-GPU (https://github.com/ccsb-scripps/AutoDock-GPU/wiki)
    > needs to be installed on a compute server with GPUs


## Receptor pre-processing

DGAPN was tested for targeted docking, in which a functional binding
site is defined. Therefore, previous structural knowledge about the
protein is needed to specify a search box that includes the side chains
of amino acids forming the region of interest.

The receptor input files provided in these resources are for docking in
the catalytic site of NSP15. In order to create the required files for a
new receptor these steps can be followed.

#### 1.  Define the docking space

> Using the graphical interface of AutoDockTools, define the docking
> space and generate the inputs to run AutoGrid4 as described:

-   After removing coordinates of water and other non-bound molecules,
    > open the PDB file of the receptor:

> *Grid \> Macromolecule \> Open*
>
> Save as PDBQT

-   Define a list of atom types that your ligands may contain:

> *Set map types \> Directly*
>
> Based on the chemical space explored by CReM, use: A Br C Cl F HD N NA
> OA S SA

-   Define the docking space:

> *Grid \> Grid box*
>
> Use spacing = 1 Å and define the dimensions and position of the
> docking space.
>
> *File \> Close saving current*
>
> *Grid \> Output \> Save GPF*

#### 2.  Calculate grid maps

> Pre-calculate atom-specific maps of energy of interaction running
> AutoGrid4:
>
> `<AUTOGRID4_INSTALL_DIR>/bin/autogrid4 -p \[file\].gpf`

Save .map, .maps.fld, .maps.xyz, and .pdbqt files at
`/src/reward/adtgpu/receptor`. These files, generated by
AutoGrid4, are inputs for AutoDock-GPU.


## Receptor-specific inputs for AutoDock-GPU

> ● .map files: One for each atom type, they provide electrostatic
> potential and desolvation free energy grid maps, for the given target
> macromolecule.
>
> ● .maps.fld file: Describes the consistent set of atomic affinity grid
> maps.
>
> ● .maps.xyz file: Describes the dimensions and position of the grid
> box.
>
> ● .pdbqt file: Contains the atomic coordinates, partial charges, and
> AutoDock atom types of the receptor.


## Molecular docking within DGAPN

In [the python script](get_reward.py), provide the path to Open Babel and AutoDock-GPU binaries:

```bash
#Executable paths

OBABEL_PATH=\"\<OBABEL_INSTALL_DIR>/bin/obabel\"

ADT_PATH=\"\<AUTODOCK_GPU_INSTALL_DIR>/bin/\<AUTODOCK_GPU_EXECUTABLE>\"

#Receptor paths

RECEPTOR_FILE=\"\<NAME_OF_RECEPTOR>.pdbqt\"
```


## Summary of the AutoDock-GPU processing workflow

#### 1.  Using RDKit, the chemical validity of the SMILES strings of the
    > generated molecules is checked. If valid, the SMILES are converted
    > into PDB, using the `Chem.MolToPDBBlock` module. Invalid
    > SMILES are given a score of 0.0

#### 2.  PDB files are converted to PDBQT, using Open Babel. Both the PDB and
    > PDBQT formats are temporarily saved in a `/ligands/`
    > sub-directory, under the work directory

#### 3.  A list of all PDBQT ligands to be evaluated is stored in a text file
    > in the `/ligands/` sub-directory

#### 4.  Molecular docking is performed using AutoDock-GPU

#### 5.  Output is parsed to fetch the docking scores, the negative of the
    > docking score is returned for all SMILES as reward scores. The
    > reward function for DGAPN (`get_dock_score`) is defined
    > in `/src/reward/adtgpu/get_reward.py`
