import os
from index_paths import THE_TOPICS 
import subprocess
import pickle

def write_scores_to_file(all_qids, all_docids, scores, output_filename):
    output_filename = f'{output_filename}'
    with open(output_filename, 'w')  as f:
        rerank_scores = [{'qid': qid, 'docid': docid, 'score': score} for qid, docid, score in zip(all_qids, all_docids, scores)]
        reranked_scores_sorted = sorted(
                rerank_scores,
                key=lambda x: (x['qid'], -x['score'])
            )
        
        rank = 0
        prev_qid = None
        for document in reranked_scores_sorted:
            qid = document["qid"]
            if qid != prev_qid:
                rank = 1
                prev_qid = qid
            else:
                rank += 1
            f.write(f'{qid} Q0 {document["docid"]} {rank} {document["score"]} rank\n')

def save_outputs_to_pkl(all_qids, all_docids, outputs, output_filename):
        with open(f'{output_filename}.reasoning_chains.pkl', 'wb') as file:
            output_list = []
            for qid, docid, reasoning in zip(all_qids, all_docids, outputs):
                output_list.append([qid, docid, reasoning])
            pickle.dump(output_list, file)
                
def evaluate(corpus_name, output_filename, qrels_path=None):
    # Eval!
    if corpus_name in ['dl21', 'dl22', 'dl23']:
        qrels_name = f'{THE_TOPICS[corpus_name]}-passage'
    elif corpus_name in ["biology", "earth_science", "economics", "psychology", "robotics", "stackoverflow", "sustainable_living", "pony", "leetcode", "aops", "theoremqa_theorems", "theoremqa_questions"]:
        assert(qrels_path is not None)
        qrels_name = qrels_path
    else:
        qrels_name = THE_TOPICS[corpus_name]

    print(os.system(f"python -m pyserini.eval.trec_eval -c -m ndcg_cut.10 {qrels_name} {output_filename}"))