import numpy as np
import time
from scipy.linalg import orth
from sklearn.preprocessing import MinMaxScaler

def tansig(x):
    return 2 / (1 + np.exp(-2 * x)) - 1

# def one_hot(x, n_class):
#     y = np.zeros([len(x), n_class])
#     U_dataY_train = np.unique(x)
#     for i in range(n_class):
#         idx = (x == U_dataY_train[i])
#         y[idx, i] = 1
#     return y

def one_hot(x, n_class):
    y = np.zeros((len(x), n_class))
    for i in range(n_class):
        idx = (x == i)
        y[idx, i] = 1
    return y

def BLS_Model(trainX, trainY, testX, testY, option, num_classes):
    C1 = option['C']
    N1 = option['N']
    N2 = option['NN']
    N3 = option['NNN']
    N4 = option['N4']

    start_train = time.time()
    Nsample, Nfea = trainX.shape
    trainY_one_hot = one_hot(trainY, num_classes)

    H1 = np.hstack((trainX, 0.1 * np.ones((Nsample, 1))))
    Z = []
    We = []

    # Feature Mapping Layer
    for _ in range(N2):
        we = 2 * np.random.rand(Nfea + 1, N1) - 1
        We.append(we)
        A1 = np.dot(H1, we)
        A1 = MinMaxScaler(feature_range=(-1, 1)).fit_transform(A1)
        Z.append(A1)
    Z = np.hstack(Z)

    # Enhancement Layer
    H_list = []
    Wh = []
    for _ in range(N4):
        H2 = np.hstack((Z, 0.1 * np.ones((Nsample, 1))))
        if N1 * N2 >= N3:
            wh = orth(2 * np.random.rand(N1 * N2 + 1, N3) - 1)
        else:
            wh = orth((2 * np.random.rand(N1 * N2 + 1, N3).T - 1)).T
        Wh.append(wh)
        A2 = tansig(np.dot(H2, wh))
        H_list.append(A2)

    H_all = np.hstack(H_list)
    X = np.hstack((Z, H_all))

    # Output Weights (beta)
    if X.shape[1] < Nsample:
        beta = np.dot(np.linalg.inv(np.eye(X.shape[1]) / C1 + np.dot(X.T, X)), np.dot(X.T, trainY_one_hot))
    else:
        beta = np.dot(X.T, np.dot(np.linalg.inv(np.eye(X.shape[0]) / C1 + np.dot(X, X.T)), trainY_one_hot))

    # Train Accuracy
    train_output = np.dot(X, beta)
    train_time = time.time() - start_train
    train_probs = np.exp(train_output - np.max(train_output, axis=1, keepdims=True))
    train_probs /= np.sum(train_probs, axis=1, keepdims=True)
    train_preds = np.argmax(train_probs, axis=1)
    train_acc = np.mean(train_preds == np.argmax(trainY_one_hot, axis=1)) * 100

    # Testing Phase
    start_test = time.time()
    testY_one_hot = one_hot(testY, num_classes)
    Nsample_test = testX.shape[0]
    Z_test = []
    T1 = np.hstack((testX, 0.1 * np.ones((Nsample_test, 1))))
    for i in range(N2):
        T2 = np.dot(T1, We[i])
        T2 = MinMaxScaler(feature_range=(-1, 1)).fit_transform(T2)
        Z_test.append(T2)
    Z_test = np.hstack(Z_test)

    H_test_list = []
    I2 = np.hstack((Z_test, 0.1 * np.ones((Nsample_test, 1))))
    for i in range(N4):  # ✅ Match enhancement window count
        A2 = tansig(np.dot(I2, Wh[i]))
        H_test_list.append(A2)
    H_test_all = np.hstack(H_test_list)

    Z_test_final = np.hstack((Z_test, H_test_all))
    test_output = np.dot(Z_test_final, beta)
    test_time = time.time() - start_test

    test_probs = np.exp(test_output - np.max(test_output, axis=1, keepdims=True))
    test_probs /= np.sum(test_probs, axis=1, keepdims=True)
    test_preds = np.argmax(test_probs, axis=1)
    test_acc = np.mean(test_preds == np.argmax(testY_one_hot, axis=1)) * 100

    return train_acc, test_acc, train_time, test_time
