import os
import numpy as np
import scipy.io
from sklearn.preprocessing import StandardScaler
from BLS_Model import BLS_Model

# File to save results
result_file = r"PATH_TO_SAVE_RESULTS"
with open(result_file, 'w') as result:
    result.write("DataSetName\tBestMeanTrainAccuracy\tBestStdTrainAccuracy\tBestMeanTestAccuracy\t"
                 "BestStdTestAccuracy\tBestMeanTrainTime\tBestStdTrainTime\t"
                 "BestMeanTestTime\tBestStdTestTime\tBest_C\tBest_N1\tBest_N2\tBest_N3\tBest_N4\n")

directory = r"PATH_TO_YOUR_DATASET_FOLDER"
files = [f for f in os.listdir(directory) if f.endswith('.txt')]

print(files)

for file in files:
    data_path = os.path.join(directory, file)
    
    try:
        all_data = np.loadtxt(data_path)
        
        all_data[all_data[:, -1] == -1, -1] = 0

        X = StandardScaler().fit_transform(all_data[:, :-1])
        y = all_data[:, -1]
        all_data = np.hstack((X, y.reshape(-1, 1)))

        num_classes = len(np.unique(y))
        length_train = all_data.shape[0]

        print(f"{file}: samples = {length_train}, classes = {num_classes}")

    except Exception as e:
        print(f"Error loading {file}: {e}")


    # Hyperparameters
    C1 = 10.0 ** np.arange(-5, 6)
    N = np.arange(5, 51, 5)
    NN = np.arange(1, 22, 2)
    NNN = np.arange(5, 106, 10)
    NNNN = [1]  # This must be a list or iterable to use in a for loop

    best_metrics = {
        'MeanTrainAccuracy': 0,
        'MeanTestAccuracy': 0,
    }

    for c_1 in C1:
        for N1 in N:
            for N2 in NN:
                for N3 in NNN:
                    for N4 in NNNN:
                        temp_results = []
                        temp_test_accuracy = []
                        block_size = length_train // 5

                        for part in range(5):
                            t1 = part * block_size
                            t2 = (part + 1) * block_size

                            test_data = all_data[t1:t2, :]
                            train_data = np.vstack((all_data[:t1, :], all_data[t2:, :]))

                            trainX, trainY = train_data[:, :-1], train_data[:, -1]
                            testX, testY = test_data[:, :-1], test_data[:, -1]

                            option = {'C': c_1, 'N': N1, 'NN': N2, 'NNN': N3, 'N4': N4}

                            train_acc, valid_acc, train_time, valid_time = BLS_Model(
                                trainX, trainY, testX, testY, option, num_classes
                            )

                            temp_results.append([train_acc, valid_acc, train_time, valid_time])
                            temp_test_accuracy.append(valid_acc)

                        mean_test_accuracy = np.mean(temp_test_accuracy)
                        if mean_test_accuracy > best_metrics['MeanTestAccuracy']:
                            best_metrics.update({
                                'MeanTrainAccuracy': np.mean(np.array(temp_results)[:, 0]),
                                'StdTrainAccuracy': np.std(np.array(temp_results)[:, 0]),
                                'MeanTestAccuracy': mean_test_accuracy,
                                'StdTestAccuracy': np.std(np.array(temp_results)[:, 1]),
                                'MeanTrainTime': np.mean(np.array(temp_results)[:, 2]),
                                'StdTrainTime': np.std(np.array(temp_results)[:, 2]),
                                'MeanTestTime': np.mean(np.array(temp_results)[:, 3]),
                                'StdTestTime': np.std(np.array(temp_results)[:, 3]),
                                'C1': c_1,
                                'N': N1,
                                'NN': N2,
                                'NNN': N3,
                                'NNNN': N4,
                            })

    with open(result_file, 'a') as result:
        result.write(f"{file}\t{best_metrics.get('MeanTrainAccuracy', 0):.4f}\t{best_metrics.get('StdTrainAccuracy', 0):.4f}\t"
                     f"{best_metrics.get('MeanTestAccuracy', 0):.4f}\t{best_metrics.get('StdTestAccuracy', 0):.4f}\t"
                     f"{best_metrics.get('MeanTrainTime', 0):.6f}\t{best_metrics.get('StdTrainTime', 0):.6f}\t"
                     f"{best_metrics.get('MeanTestTime', 0):.6f}\t{best_metrics.get('StdTestTime', 0):.6f}\t"
                     f"{best_metrics.get('C1', 0.0):.6f}\t{best_metrics.get('N', 0)}\t{best_metrics.get('NN', 0)}\t"
                     f"{best_metrics.get('NNN', 0)}\t{best_metrics.get('NNNN', 0)}\n")

    print(f"Completed processing for {file}")
