import numpy as np
import time

def ELM_Model(trainX, trainY, testX, testY, option, No_of_class):
    N = option['N']
    C = option['C']
    s = 1  # Scaling factor
    activation = option['activation']

    def one_hot_encode(labels, num_classes):
        one_hot = np.zeros((len(labels), num_classes))
        one_hot[np.arange(len(labels)), labels.astype(int)] = 1
        return one_hot

    trainY_one_hot = one_hot_encode(trainY, No_of_class)

    # Start training
    start_time = time.time()
    Nsample, Nfea = trainX.shape

    # Random weights and biases
    W = np.random.uniform(-s, s, (Nfea, N))
    b = np.random.uniform(0, s, N)

    # Hidden layer output
    H = np.dot(trainX, W) + b

    if activation == 1:
        H = 1 / (1 + np.exp(-H))  # Sigmoid
    elif activation == 2:
        H = np.sin(H)  # Sine
    elif activation == 3:
        H = np.maximum(0, 1 - np.abs(H))  # Tribas
    elif activation == 4:
        H = np.exp(-H**2)  # Radbas
    elif activation == 5:
        H = np.tanh(H)  # Tansig
    elif activation == 6:
        H = np.maximum(0, H)  # ReLU

    # Compute output weights (beta)
    if H.shape[1] < Nsample:
        beta = np.linalg.solve(np.eye(H.shape[1]) / C + H.T @ H, H.T @ trainY_one_hot)
    else:
        beta = H.T @ np.linalg.solve(np.eye(Nsample) / C + H @ H.T, trainY_one_hot)

    trainY_pred = H @ beta
    train_time = time.time() - start_time

    # Softmax for multiclass output
    train_probs = np.exp(trainY_pred - np.max(trainY_pred, axis=1, keepdims=True))
    train_probs /= np.sum(train_probs, axis=1, keepdims=True)
    train_preds = np.argmax(train_probs, axis=1)
    train_acc = np.mean(train_preds == np.argmax(trainY_one_hot, axis=1)) * 100

    # Start testing
    start_time = time.time()

    testY_one_hot = one_hot_encode(testY, No_of_class)
    Nsample_test = testX.shape[0]
    H_test = np.dot(testX, W) + b

    if activation == 1:
        H_test = 1 / (1 + np.exp(-H_test))
    elif activation == 2:
        H_test = np.sin(H_test)
    elif activation == 3:
        H_test = np.maximum(0, 1 - np.abs(H_test))
    elif activation == 4:
        H_test = np.exp(-H_test**2)
    elif activation == 5:
        H_test = np.tanh(H_test)
    elif activation == 6:
        H_test = np.maximum(0, H_test)

    testY_pred = H_test @ beta
    test_time = time.time() - start_time

    test_probs = np.exp(testY_pred - np.max(testY_pred, axis=1, keepdims=True))
    test_probs /= np.sum(test_probs, axis=1, keepdims=True)
    test_preds = np.argmax(test_probs, axis=1)
    test_acc = np.mean(test_preds == np.argmax(testY_one_hot, axis=1)) * 100

    return train_acc, test_acc, train_time, test_time
