import numpy as np
import time



def RVFL_Model(trainX, trainY, testX, testY, option, No_of_class):
    N = option['N']
    C = option['C']
    s = 1  # Scaling factor
    activation = option['activation']

    # Convert labels to one-hot encoding
    def one_hot_encode(labels, num_classes):
        one_hot = np.zeros((len(labels), num_classes))
        one_hot[np.arange(len(labels)), labels.astype(int)] = 1
        return one_hot

    trainY_one_hot = one_hot_encode(trainY, No_of_class)

    # Start training
    start_time = time.time()

    Nsample, Nfea = trainX.shape
    W = np.random.uniform(-s, s, (Nfea, N))
    b = np.random.uniform(0, s, N)

    X1 = np.dot(trainX, W) + b

    # Activation functions
    if activation == 1:
        X1 = 1 / (1 + np.exp(-X1))  # Sigmoid
    elif activation == 2:
        X1 = np.sin(X1)  # Sine
    elif activation == 3:
        X1 = np.maximum(0, 1 - np.abs(X1))  # Tribas
    elif activation == 4:
        X1 = np.exp(-X1**2)  # Radbas
    elif activation == 5:
        X1 = np.tanh(X1)  # Tansig
    elif activation == 6:
        X1 = np.maximum(0, X1) #RELU

    X = np.hstack([trainX, X1, np.ones((Nsample, 1))])  # Direct Link with bias

    if X.shape[1] < Nsample:
        beta = np.linalg.solve(np.eye(X.shape[1]) / C + np.dot(X.T, X), np.dot(X.T, trainY_one_hot))
    else:
        beta = np.dot(X.T, np.linalg.solve(np.eye(Nsample) / C + np.dot(X, X.T), trainY_one_hot))

    trainY_pred = np.dot(X, beta)
    train_time = time.time() - start_time

    # Softmax and accuracy calculation
    train_probs = np.exp(trainY_pred - np.max(trainY_pred, axis=1, keepdims=True))
    train_probs /= np.sum(train_probs, axis=1, keepdims=True)
    train_preds = np.argmax(train_probs, axis=1)
    train_acc = np.mean(train_preds == np.argmax(trainY_one_hot, axis=1)) * 100

    # Start testing
    start_time = time.time()

    testY_one_hot = one_hot_encode(testY, No_of_class)

    Nsample = testX.shape[0]
    X1 = np.dot(testX, W) + b

    # Activation functions
    if activation == 1:
        X1 = 1 / (1 + np.exp(-X1))  # Sigmoid
    elif activation == 2:
        X1 = np.sin(X1)  # Sine
    elif activation == 3:
        X1 = np.maximum(0, 1 - np.abs(X1))  # Tribas
    elif activation == 4:
        X1 = np.exp(-X1**2)  # Radbas
    elif activation == 5:
        X1 = np.tanh(X1)  # Tansig
    elif activation == 6:
        X1 = np.maximum(0, X1) #RELU


    X = np.hstack([testX, X1, np.ones((Nsample, 1))])

    testY_pred = np.dot(X, beta)
    test_time = time.time() - start_time

    test_probs = np.exp(testY_pred - np.max(testY_pred, axis=1, keepdims=True))
    test_probs /= np.sum(test_probs, axis=1, keepdims=True)
    test_preds = np.argmax(test_probs, axis=1)
    test_acc = np.mean(test_preds == np.argmax(testY_one_hot, axis=1)) * 100

    return train_acc, test_acc, train_time, test_time
