%Input:
%---train_x,test_x : the training data and learning data
%---train_y,test_y : the label
%---We: the randomly generated coefficients of feature nodes
%---wh:the randomly generated coefficients of enhancement nodes
%----s: the shrinkage parameter for enhancement nodes
%----N1: the number of feature nodes  per window
%----N2: the number of windows of feature nodes
%----N3: the number of enhancement nodes  per window
%----N4: the number of windows of enhancement nodes
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
clc;
Directory=dir('PATH_TO_YOUR_DATASET_FOLDER\*.txt');
l=length(Directory);

Result=fopen('PATH_TO_SAVE_RESULTS\results.txt', 'w');
fprintf(Result,"DataSetName\t BestMeanTrainAccuracy\t BestStdTrainAccuracy\t BestMeanTestAccuracy\t BestStdTestAccuracy\t MeanSentivity\t  StdSensitivity\t    Meanspecificity\t    Stdspecificity\t    Meanprecision\t  Stdprecision\t  MeanFmeasure\t  StdFmeasure\t  MeanGmean\t  StdGmean\t  Best_C\t     Best_N1\t    Best_N2\t    Best_N3\t \n");

for u=1:l
    t1 = strcat('PATH_TO_YOUR_DATASET_FOLDER\', Directory(u).name);

    All_data=importdata(t1);

    [m,n]=size(All_data);
    for i=1:m
        if All_data(i,n)==-1
            All_data(i,n)=0;
        end
    end

    All_X_data=zscore((All_data(:,1:end-1))')';
    All_Y_data=All_data(:,end);
    All_data=[All_X_data,All_Y_data];

    [length_train,~] = size(All_data);

    classes = unique(All_data(:,end));
    option.nclass = length(classes);

    C=[10^-5,10^-4,10^-3,10^-2,10^-1,10^0,10^1,10^2,10^3,10^4,10^5];
    N1=(5:5:50);
    N2=[1,3,5,7,9,11,13,15,17,19,21];
    N3=(5:10:105);
    N4=1;

    no_part=5;
    BestMeanTrainAccuracy=0;
    BestMeanTestAccuracy=0;

    for jj=1:length(C)
        option.c=C(jj)
        for kk = 1:length(N1)
            option.n1 = N1(kk)
            for ll = 1:length(N2)
                option.n2 = N2(ll)
                for mm = 1:length(N3)
                    option.n3=N3(mm)

                    t1

                    block_size = length_train/(no_part*1.0);
                    part = 0;
                    t_1 = 0;
                    t_2 = 0;
                    while ceil((part+1) * block_size) <= length_train
                        % crossvalidation
                        if part==0
                            t_1 = ceil(part*block_size);
                            t_2 = ceil((part+1)*block_size);
                            DataTest = All_data(t_1+1 :t_2,:);
                            DataTrain = All_data(t_2+1:length_train,:);
                        elseif part==no_part-1
                            t_1 = ceil(part*block_size);
                            t_2 = ceil((part+1)*block_size);
                            DataTest = All_data(t_1+1 :t_2,:);
                            DataTrain = All_data(1:t_1,:);
                        else
                            t_1 = ceil(part*block_size);
                            t_2 = ceil((part+1)*block_size);
                            DataTest = All_data(t_1+1 :t_2,:);
                            DataTrain = [All_data(1:t_1,:); All_data(t_2+1:length_train,:)];
                        end
                        trainX=DataTrain(:,1:end-1);
                        trainY=DataTrain(:,end);
                        testX=DataTest(:,1:end-1);
                        testY=DataTest(:,end);
                        %% testing and training
                        [EVAL_Train,EVAL_Test,train_time,valid_time] = function_BLS(trainX,trainY,testX,testY,option);

                        TempResult(part+1,:)=[EVAL_Train(1,1),EVAL_Test,train_time,valid_time];
                        TempTestingAccuracy(part+1,:)=EVAL_Test(1,1);
                        part = part+1;
                    end
                    %% Checking Accuracy
                    if BestMeanTestAccuracy < mean(TempTestingAccuracy)

                        BestMeanTestAccuracy = mean(TempTestingAccuracy);

                        E2(1,1) = mean(TempResult(:,1)); %BestMeanTrainAccuracy
                        E2(1,2) = std(TempResult(:,1)); %BestStdTrainAccuracy

                        E2(1,3) = mean(TempResult(:,2)); %BestMeanTestAccuracy
                        E2(1,4) = std(TempResult(:,2)); %BestStdTestAccuracy

                        E1(1,5) = mean(TempResult(:,3)); %sensitivity
                        E1(1,6) = std(TempResult(:,3));

                        E1(1,7) = mean(TempResult(:,4)); %specificity
                        E1(1,8) = std(TempResult(:,4));

                        E1(1,9) = mean(TempResult(:,5)); %precision
                        E1(1,10) = std(TempResult(:,5));

                        E1(1,11) = mean(TempResult(:,6)); %f_measure
                        E1(1,12) = std(TempResult(:,6));

                        E1(1,13) = mean(TempResult(:,7));  %gmean
                        E1(1,14) = std(TempResult(:,7));


                        best.C=option.c;
                        best.N1=option.n1;
                        best.N2=option.n2;
                        best.N3=option.n3;
                        best.N4=1;

                    end
                    if BestMeanTestAccuracy == 100
                        break
                    end
                end
                if BestMeanTestAccuracy == 100
                    break
                end
            end
            if BestMeanTestAccuracy == 100
                break
            end
        end
        if BestMeanTestAccuracy == 100
            break
        end
    end

    fprintf(Result,"%s\t %0.4f\t %0.4f\t %0.4f\t %0.4f\t %0.4f\t %0.4f\t %0.4f\t %0.4f\t %0.4f\t %0.4f\t %0.4f\t %0.4f\t %0.4f\t %0.4f\t %0.6f\t %d\t %d\t %d\t \n",Directory(u).name,E2(1,1),E2(1,2),E2(1,3),E2(1,4),E1(1,5),E1(1,6),E1(1,7),E1(1,8),E1(1,9),E1(1,10),E1(1,11),E1(1,12),E1(1,13),E1(1,14),best.C,best.N1,best.N2,best.N3);
end
fclose('all');