function [EVAL_Train,EVAL_Test,TrainTime,TestTime] = function_BLS(trainX,trainY,testX,testY,option)


train_x=trainX;
N1=option.n1;
N2=option.n2;
N3=option.n3;
N4=1;
C=option.c;
nclass=option.nclass;

dataY_train_temp = zeros(size(trainY, 1), nclass);
for i = 1:size(trainY, 1)
    dataY_train_temp(i, trainY(i) + 1) = 1; % assuming classes are labeled from 0 to num_classes-1
end

[Nsample,~]=size(train_x);


tic
H1 = [train_x .1 * ones(size(train_x,1),1)];
Z=[];
for i=1:N2
    we=2*rand(size(train_x,2)+1,N1)-1;

    We{i}=we;
    A1 = H1 * we;
    A1 = mapminmax(A1);
    Z=[Z,A1];
    clear we;
    clear A1;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%Enhancement Layer%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for i=1:N4 %This loop is not taken in the original code, they just took only one window in the enhancement layer
H2 = [Z .1 * ones(size(trainY,1),1)];
if N1*N2>=N3
     wh=orth(2*rand(N2*N1+1,N3)-1);
else
    wh=orth(2*rand(N2*N1+1,N3)'-1)'; 
end

Wh{i}=wh;
H=[];
   
    A2 = H2 * wh;
    A2=tansig(A2);
    H=[H,A2];
    clear wh;
    clear A2;
end

A=[Z,H];

%%%%%%%%%%%%%%%% BLS SOLUTION %%%%%%%%%%%%%%
if size(A,2)<Nsample %i.e. No of columns of X is less than Nsample
    W = (eye(size(A,2))/C+A'*A) \ A'*dataY_train_temp;  
else
    W = A'*((eye(size(A,1))/C+A*A') \ dataY_train_temp);
end
TrainTime=toc;
Model.W=W;
Model.Wh=Wh;
Model.We=We;
% trainY_temp=A*W;
Predict_Y_train=A*W;
[~, Predict_Y_train] = max(Predict_Y_train, [], 2);

% Convert trainYrand back to class labels
[~, dataY_train_temp] = max(dataY_train_temp, [], 2);

EVAL_Train = Evaluate(dataY_train_temp,Predict_Y_train);


dataY_test_temp = zeros(size(testY, 1), nclass);
for i = 1:size(testY, 1)
    dataY_test_temp(i, testY(i) + 1) = 1; % assuming classes are labeled from 0 to num_classes-1
end
tic

% beta=Model.beta;
Wh=Model.Wh;
We=Model.We;

Z_test=[];

T1 = [testX .1 * ones(size(testX,1),1)];

for i=1:N2
    T2 = T1 * We{i};
    T2 = mapminmax(T2);
    Z_test=[Z_test,T2];
end

for i=1:N4 %This loop is not taken in the original code, they just took only one window in the enhancement layer
I2 = [Z_test .1 * ones(size(testY,1),1)];
H_test=[];
    S2 = I2 * Wh{i};
    S2=tansig(S2);
    H_test=[H_test,S2];
    clear S2;
end

B=[Z_test,H_test];


testY_temp=B*W;

[~, Predict_Y_test] = max(testY_temp, [], 2);

% Convert dataY_test_temp back to class labels
[~, testY] = max(dataY_test_temp, [], 2);


EVAL_Test = Evaluate(testY,Predict_Y_test);
TestTime=toc;
end


