clear;
clc;

Result=fopen('PATH_TO_SAVE_RESULTS\results.txt', 'w');
fprintf(Result,"DataSetName\t BestMeanTrainAccuracy\t BestStdTrainAccuracy\t BestMeanTestAccuracy\t BestStdTestAccuracy\t BestMeanTrainTime\t BestStdTrainTime\t BestMeanTestTime\t BestStdTestTime\t   Best_C\t   Best_N\t  Best_Activation  \n");

Directory=dir('PATH_TO_YOUR_DATASET_FOLDER\*.txt'); 
l=length(Directory);

for u=1:l
    t1 = strcat('PATH_TO_YOUR_DATASET_FOLDER\', Directory(u).name);

    All_data=importdata(t1);

    [m,n]=size(All_data);
    for i=1:m
        if All_data(i,n)==-1
            All_data(i,n)=0;
        end
    end

    All_X_data=zscore(All_data(:,1:end-1)')';
    All_Y_data=All_data(:,end);
    All_data=[All_X_data,All_Y_data];

    [length_train,~] = size(All_data);

    classes = unique(All_data(:,end));
    option.nclass = length(classes);

    activation = 1:1:5;

    C=[10^-5,10^-4,10^-3,10^-2,10^-1,10^0,10^1,10^2,10^3,10^4,10^5];
    N=(3:20:203);
    BestMeanTrainAccuracy=0;
    BestMeanTestAccuracy=0;

    no_part=5;

    for ii=1:size(C,2)
        option.C=C(1,ii)
        for jj=1:size(N,2)
            option.N=N(1,jj)
            for kk=1:size(activation,2)
                option.activation=activation(1,kk)


                

                    %%Cross Validation
                    block_size = length_train/(no_part*1.0);
                    part = 0;
                    t_1 = 0;
                    t_2 = 0;
                    while ceil((part+1) * block_size) <= length_train
                        %% seprating testing and training datapoints for
                        % crossvalidation
                        if part==0
                            t_1 = ceil(part*block_size);
                            t_2 = ceil((part+1)*block_size);
                            DataTest = All_data(t_1+1 :t_2,:);
                            DataTrain = All_data(t_2+1:length_train,:);
                        elseif part==no_part-1
                            t_1 = ceil(part*block_size);
                            t_2 = ceil((part+1)*block_size);
                            DataTest = All_data(t_1+1 :t_2,:);
                            DataTrain = All_data(1:t_1,:);
                        else
                            t_1 = ceil(part*block_size);
                            t_2 = ceil((part+1)*block_size);
                            DataTest = All_data(t_1+1 :t_2,:);
                            DataTrain = [All_data(1:t_1,:); All_data(t_2+1:length_train,:)];
                        end
                        trainX=DataTrain(:,1:end-1);
                        trainY=DataTrain(:,end);
                        testX=DataTest(:,1:end-1);
                        testY=DataTest(:,end);

                        [TrainingTime,TestingTime,TrainingAccuracy,TestingAccuracy] = RVFL_train(trainX, trainY, testX,testY, option);

                        TempResult(part+1,:)=[TrainingAccuracy,TestingAccuracy,TrainingTime,TestingTime];
                        TempTestingAccuracy(part+1,:)=TestingAccuracy;

                        part = part+1;
                    end
                    if BestMeanTestAccuracy < mean(TempTestingAccuracy)

                        BestMeanTrainAccuracy = mean(TempResult(:,1));
                        BestStdTrainAccuracy = std(TempResult(:,1));

                        BestMeanTestAccuracy = mean(TempResult(:,2));
                        BestStdTestAccuracy = std(TempResult(:,2));

                        BestMeanTrainTime=mean(TempResult(:,3));
                        BestStdTrainTime=std(TempResult(:,3));

                        BestMeanTestTime=mean(TempResult(:,4));
                        BestStdTestTime=std(TempResult(:,4));

                        best.C=option.C;
                        best.N=option.N;
                        best.actication=option.activation;
                        
                    end
                    if BestMeanTestAccuracy == 100
                        break
                    end
                end
                if BestMeanTestAccuracy == 100
                    break
                end
            end
            if BestMeanTestAccuracy == 100
                break
            end
        end
        
    fprintf(Result,"%s\t %0.4f\t %0.4f\t %0.4f\t %0.4f\t %0.4f\t %0.4f\t %0.4f\t %0.4f\t %0.6f\t %0.6f\t  %d\t\n",Directory(u).name,BestMeanTrainAccuracy,BestStdTrainAccuracy,BestMeanTestAccuracy,BestStdTestAccuracy,BestMeanTrainTime,BestStdTrainTime,BestMeanTestTime,BestStdTestTime,best.C,best.N,best.actication);
end
fclose('all');

