function [TrainingTime,TestingTime,TrainingAccuracy,TestingAccuracy] = RVFL_ELM_train(trainX, trainY, testX,testY, option)

% Parameters
N = option.N;          % Number of hidden nodes
C = option.C;          % Regularization parameter
s = 1;                 % Scaling factor for random weights and biases
activation = option.activation; % Activation function
nclass=option.nclass;

% Size of the input data
[Nsample, Nfea] = size(trainX);



dataY_train_temp = zeros(size(trainY, 1), nclass);
for i = 1:size(trainY, 1)
    dataY_train_temp(i, trainY(i) + 1) = 1; % assuming classes are labeled from 0 to num_classes-1
end

tic; % Start timing

% Step 1: Initialize random weights and biases
W = (rand(Nfea, N) * 2 * s - 1); % Random weight matrix
b = s * rand(1, N);              % Random biases


% Step 3: Compute hidden layer outputs
X1 = trainX * W + repmat(b, Nsample, 1);

%Applying Activation
if activation == 1
    X1 = sigmoid(X1);
elseif activation == 2
    X1 = sin(X1);
elseif activation == 3
    X1 = tribas(X1);
elseif activation == 4
    X1 = radbas(X1);
elseif activation == 5
    X1 = tansig(X1);
elseif activation == 6
    X1 = relu(X1);
end
% Step 4: Concatenate input and hidden layer outputs, add bias term

% X = [trainX, X1];     %%%% For RVFL
X=X1;                   %%%% For ELM

X = [X, ones(Nsample, 1)];

% Step 5: Compute output weights (beta)
if size(X, 2) < Nsample
    beta = (eye(size(X, 2)) * (1 / C) + X' * X) \ X' * dataY_train_temp;
else
    beta = X' * ((eye(size(X, 1)) * (1 / C) + X * X') \ dataY_train_temp);
end

PredictedTrainLabel = X * beta;
TrainingTime = toc;

%Training Accuracy
trainY_temp1 = bsxfun(@minus,PredictedTrainLabel,max(PredictedTrainLabel,[],2)); %for numerical stability
num = exp(trainY_temp1);
dem = sum(num,2);
prob_scores = bsxfun(@rdivide,num,dem);
[~,indx] = max(prob_scores,[],2);
[~, ind_corrClass] = max(dataY_train_temp,[],2);
TrainingAccuracy = mean(indx == ind_corrClass)*100;

%% Testing starts
tic;
%%%%%%%%%%%%% TEST DATA %%%%%%%%%%%%%%
Nsample_test = size(testX,1);
dataY_test=testY;
% U_dataY_test = [0,1];
% nclass=2;
dataY_test_temp = zeros(size(dataY_test, 1), nclass); %constructed a zero matrix of order [(Total no. of samples) times (No of class)]
% 0-1 coding for the target
for i=1:size(dataY_test, 1) %loop runs column wise
    dataY_test_temp(i, dataY_test(i) + 1) = 1; % assuming classes are labeled from 0 to num_classes-1
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

X11 = testX*W+repmat(b,Nsample_test,1);

if activation == 1
    X11 = sigmoid(X11);
elseif activation == 2
    X11 = sin(X11);
elseif activation == 3
    X11 = tribas(X11);
elseif activation == 4
    X11 = radbas(X11);
elseif activation == 5
    X11 = tansig(X11);
elseif activation == 6
    X11 = relu(X11);
end


X11=[X11,ones(Nsample_test,1)];   %%%%% For ELM
% Xt = [testX,X11];               %%%%% For RVFL
Xt=X11;
PredictedTestLabel = Xt*beta;
TestingTime = toc;

%Testing Accuracy
testY_temp1 = bsxfun(@minus,PredictedTestLabel,max(PredictedTestLabel,[],2)); %for numerical stability
num = exp(testY_temp1);
dem = sum(num,2);
prob_scores = bsxfun(@rdivide,num,dem);
[~,indx] = max(prob_scores,[],2);
[~, ind_corrClass] = max(dataY_test_temp,[],2);
TestingAccuracy = mean(indx == ind_corrClass)*100;
end
