clear;
clc;

Result = fopen('PATH_TO_SAVE_RESULTS\results.txt', 'w');
fprintf(Result, "DataSetName\t BestMeanTrainAccuracy\t BestStdTrainAccuracy\t BestMeanTestAccuracy\t BestStdTestAccuracy\t BestMeanTrainTime\t BestStdTrainTime\t BestMeanTestTime\t BestStdTestTime\t Best_C\t Best_N\t Best_Activation\t Best_rho_target\t Best_rho_min\n");

Directory = dir('PATH_TO_YOUR_DATASET_FOLDER\*.txt'); 
l = length(Directory);

for u = 1:l
    t1 = strcat('PATH_TO_YOUR_DATASET_FOLDER\', Directory(u).name);
    All_data = importdata(t1);

    % Preprocess labels
    [m, n] = size(All_data);
    All_data(All_data(:, n) == -1, n) = 0;

    % Normalize features
    All_X_data = zscore(All_data(:, 1:end-1)')';
    All_Y_data = All_data(:, end);
    All_data = [All_X_data, All_Y_data];

    [length_train, ~] = size(All_data);
    classes = unique(All_data(:, end));
    option.nclass = length(classes);

    activation = 1:5;
    C = [1e-5, 1e-4, 1e-3, 1e-2, 1e-1, 1e0, 1e1, 1e2, 1e3, 1e4, 1e5];
    N = 3:20:203;
    rho_targets = [0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0];
    rho_mins = 0.1 * rho_targets;

    BestMeanTestAccuracy = 0;
    no_part = 5;

    for ii = 1:length(C)
        option.C = C(ii);
        for jj = 1:length(N)
            option.N = N(jj);
            for kk = 1:length(activation)
                option.activation = activation(kk);
                for rr = 1:length(rho_targets)
                    option.rho_target = rho_targets(rr);
                    option.rho_min = rho_mins(rr);

                    block_size = length_train / no_part;
                    part = 0;

                    while ceil((part+1) * block_size) <= length_train
                        if part == 0
                            t_1 = ceil(part * block_size);
                            t_2 = ceil((part+1) * block_size);
                            DataTest = All_data(t_1+1 : t_2, :);
                            DataTrain = All_data(t_2+1 : end, :);
                        elseif part == no_part - 1
                            t_1 = ceil(part * block_size);
                            t_2 = ceil((part+1) * block_size);
                            DataTest = All_data(t_1+1 : t_2, :);
                            DataTrain = All_data(1 : t_1, :);
                        else
                            t_1 = ceil(part * block_size);
                            t_2 = ceil((part+1) * block_size);
                            DataTest = All_data(t_1+1 : t_2, :);
                            DataTrain = [All_data(1 : t_1, :); All_data(t_2+1 : end, :)];
                        end

                        trainX = DataTrain(:, 1:end-1);
                        trainY = DataTrain(:, end);
                        testX = DataTest(:, 1:end-1);
                        testY = DataTest(:, end);

                        [TrainingTime, TestingTime, TrainingAccuracy, TestingAccuracy] = StaR_RVFL_ELM_train(trainX, trainY, testX, testY, option);

                        TempResult(part+1,:) = [TrainingAccuracy, TestingAccuracy, TrainingTime, TestingTime];
                        TempTestingAccuracy(part+1,:) = TestingAccuracy;
                        part = part + 1;
                    end

                    if BestMeanTestAccuracy < mean(TempTestingAccuracy)
                        BestMeanTrainAccuracy = mean(TempResult(:, 1));
                        BestStdTrainAccuracy = std(TempResult(:, 1));

                        BestMeanTestAccuracy = mean(TempResult(:, 2));
                        BestStdTestAccuracy = std(TempResult(:, 2));

                        BestMeanTrainTime = mean(TempResult(:, 3));
                        BestStdTrainTime = std(TempResult(:, 3));

                        BestMeanTestTime = mean(TempResult(:, 4));
                        BestStdTestTime = std(TempResult(:, 4));

                        best.C = option.C;
                        best.N = option.N;
                        best.activation = option.activation;
                        best.rho_target = option.rho_target;
                        best.rho_min = option.rho_min;
                    end

                    if BestMeanTestAccuracy == 100
                        break;
                    end
                end
                if BestMeanTestAccuracy == 100, break; end
            end
            if BestMeanTestAccuracy == 100, break; end
        end
        if BestMeanTestAccuracy == 100, break; end
    end

    fprintf(Result, "%s\t %.4f\t %.4f\t %.4f\t %.4f\t %.4f\t %.4f\t %.4f\t %.4f\t %.6f\t %.6f\t %d\t %.3f\t %.3f\n", ...
        Directory(u).name, BestMeanTrainAccuracy, BestStdTrainAccuracy, ...
        BestMeanTestAccuracy, BestStdTestAccuracy, ...
        BestMeanTrainTime, BestStdTrainTime, BestMeanTestTime, BestStdTestTime, ...
        best.C, best.N, best.activation, best.rho_target, best.rho_min);
end

fclose('all');
