import click
import logging
import json
from collections import namedtuple

logger = logging.getLogger(__file__)


def run(args):
    # with open(args.input) as fd:
    #     data = json.load(fd)
    # valid_keys = ["conversations", "id"]
    # save_data = []
    # for item in data:
    #     item_keys = list(item.keys())
    #     for key in item_keys:
    #         if key not in valid_keys:
    #             item.pop(key)
    #     save_data.append(item)
    # with open(args.output, "w") as fd:
    #     json.dump(save_data, fd, indent=1)

    with open(args.input) as fd:
        inp_data = json.load(fd)
    with open(args.base) as fd:
        base_data = json.load(fd)

    for key in args.keys.split(","):
        for di, db in zip(inp_data, base_data):
            assert di["id"] == db["id"]
            db[key] = di[key]

    with open(args.base, "w") as fd:
        json.dump(base_data, fd, indent=1)


@click.command()
@click.option("-i", "--input", required=True)
@click.option("-k", "--keys", required=True)
@click.option("-b", "--base", required=True)
def main(**kwargs):
    Arg = namedtuple("Arg", kwargs.keys())
    args = Arg(**kwargs)
    logger.info(kwargs)
    run(args)


if __name__ == "__main__":
    logging.basicConfig(
        filename=__file__ + ".log",
        filemode="a",
        format="[%(levelname)-5.5s][%(asctime)s][%(filename)s %(lineno)d]: %(message)s",
        datefmt="%d-%m-%Y %H:%M:%S",
        level=logging.INFO,
    )
    logging.getLogger().addHandler(logging.StreamHandler())
    main()
