import { ComponentMeta } from "@storybook/react";
import { Stats as StatsType } from "src/types/Stat";

import { Stats } from "./Stats";

const data: StatsType = {
  stats_by_name: {
    human_messages_by_lang: {
      name: "human_messages_by_lang",
      last_updated: "2023-02-17T07:56:07.723464+00:00",
      stats: {
        ar: 77,
        ca: 1405,
        cs: 3,
        da: 34,
        de: 2893,
        en: 37735,
        es: 32747,
        eu: 352,
        fr: 2295,
        gl: 27,
        hu: 217,
        id: 2,
        it: 424,
        ja: 236,
        ko: 27,
        nl: 18,
        pl: 162,
        ro: 1,
        ru: 3994,
        sv: 15,
        tr: 29,
        vi: 274,
        zh: 956,
        "pt-BR": 653,
        "uk-UA": 392,
      },
    },
    human_messages_by_role: {
      name: "human_messages_by_role",
      last_updated: "2023-02-17T07:56:07.776282+00:00",
      stats: { prompter: 56319, assistant: 28649 },
    },
    message_trees_by_state: {
      name: "message_trees_by_state",
      last_updated: "2023-02-17T07:56:07.790168+00:00",
      stats: {
        growing: 1597,
        ranking: 20,
        ready_for_export: 5023,
        aborted_low_grade: 1201,
        halted_by_moderator: 1088,
        initial_prompt_review: 2174,
        prompt_lottery_waiting: 38119,
      },
    },
    users_accepted_tos: {
      name: "users_accepted_tos",
      last_updated: "2023-02-17T07:56:07.865588+00:00",
      stats: { count: 27906 },
    },
    message_trees_states_by_lang: {
      name: "message_trees_states_by_lang",
      last_updated: "2023-02-17T07:56:07.857288+00:00",
      stats: [
        { lang: "ar", count: 2, state: "aborted_low_grade" },
        { lang: "ar", count: 46, state: "growing" },
        { lang: "ar", count: 56, state: "initial_prompt_review" },
        { lang: "ar", count: 1, state: "ready_for_export" },
        { lang: "bn", count: 69, state: "initial_prompt_review" },
        { lang: "ca", count: 3, state: "aborted_low_grade" },
        { lang: "ca", count: 101, state: "growing" },
        { lang: "ca", count: 16, state: "initial_prompt_review" },
        { lang: "ca", count: 519, state: "prompt_lottery_waiting" },
        { lang: "ca", count: 133, state: "ready_for_export" },
        { lang: "cs", count: 3, state: "growing" },
        { lang: "cs", count: 31, state: "initial_prompt_review" },
        { lang: "da", count: 1, state: "aborted_low_grade" },
        { lang: "da", count: 23, state: "growing" },
        { lang: "da", count: 6, state: "initial_prompt_review" },
        { lang: "da", count: 1, state: "ready_for_export" },
        { lang: "de", count: 70, state: "aborted_low_grade" },
        { lang: "de", count: 101, state: "growing" },
        { lang: "de", count: 61, state: "initial_prompt_review" },
        { lang: "de", count: 1307, state: "prompt_lottery_waiting" },
        { lang: "de", count: 1, state: "ranking" },
        { lang: "de", count: 127, state: "ready_for_export" },
        { lang: "en", count: 817, state: "aborted_low_grade" },
        { lang: "en", count: 100, state: "growing" },
        { lang: "en", count: 978, state: "halted_by_moderator" },
        { lang: "en", count: 97, state: "initial_prompt_review" },
        { lang: "en", count: 17203, state: "prompt_lottery_waiting" },
        { lang: "en", count: 2, state: "ranking" },
        { lang: "en", count: 1669, state: "ready_for_export" },
        { lang: "es", count: 82, state: "aborted_low_grade" },
        { lang: "es", count: 101, state: "growing" },
        { lang: "es", count: 108, state: "halted_by_moderator" },
        { lang: "es", count: 101, state: "initial_prompt_review" },
        { lang: "es", count: 16624, state: "prompt_lottery_waiting" },
        { lang: "es", count: 2584, state: "ready_for_export" },
        { lang: "eu", count: 101, state: "growing" },
        { lang: "eu", count: 33, state: "initial_prompt_review" },
        { lang: "eu", count: 114, state: "prompt_lottery_waiting" },
        { lang: "eu", count: 21, state: "ready_for_export" },
        { lang: "fa", count: 2, state: "initial_prompt_review" },
        { lang: "fr", count: 56, state: "aborted_low_grade" },
        { lang: "fr", count: 100, state: "growing" },
        { lang: "fr", count: 84, state: "initial_prompt_review" },
        { lang: "fr", count: 613, state: "prompt_lottery_waiting" },
        { lang: "fr", count: 134, state: "ready_for_export" },
        { lang: "gl", count: 17, state: "growing" },
        { lang: "gl", count: 46, state: "initial_prompt_review" },
        { lang: "hu", count: 1, state: "aborted_low_grade" },
        { lang: "hu", count: 100, state: "growing" },
        { lang: "hu", count: 50, state: "initial_prompt_review" },
        { lang: "hu", count: 44, state: "prompt_lottery_waiting" },
        { lang: "hu", count: 4, state: "ready_for_export" },
        { lang: "id", count: 1, state: "aborted_low_grade" },
        { lang: "id", count: 2, state: "growing" },
        { lang: "id", count: 24, state: "initial_prompt_review" },
        { lang: "it", count: 1, state: "aborted_low_grade" },
        { lang: "it", count: 101, state: "growing" },
        { lang: "it", count: 38, state: "initial_prompt_review" },
        { lang: "it", count: 77, state: "prompt_lottery_waiting" },
        { lang: "it", count: 3, state: "ranking" },
        { lang: "it", count: 14, state: "ready_for_export" },
        { lang: "ja", count: 15, state: "aborted_low_grade" },
        { lang: "ja", count: 99, state: "growing" },
        { lang: "ja", count: 39, state: "initial_prompt_review" },
        { lang: "ja", count: 3, state: "ready_for_export" },
        { lang: "ko", count: 3, state: "growing" },
        { lang: "ko", count: 415, state: "initial_prompt_review" },
        { lang: "ko", count: 4, state: "ready_for_export" },
        { lang: "nl", count: 15, state: "growing" },
        { lang: "nl", count: 155, state: "initial_prompt_review" },
        { lang: "pl", count: 2, state: "aborted_low_grade" },
        { lang: "pl", count: 56, state: "growing" },
        { lang: "pl", count: 142, state: "initial_prompt_review" },
        { lang: "pl", count: 9, state: "ready_for_export" },
        { lang: "pt-BR", count: 16, state: "aborted_low_grade" },
        { lang: "pt-BR", count: 100, state: "growing" },
        { lang: "pt-BR", count: 60, state: "initial_prompt_review" },
        { lang: "pt-BR", count: 260, state: "prompt_lottery_waiting" },
        { lang: "pt-BR", count: 1, state: "ranking" },
        { lang: "pt-BR", count: 10, state: "ready_for_export" },
        { lang: "ro", count: 1, state: "growing" },
        { lang: "ro", count: 142, state: "initial_prompt_review" },
        { lang: "ru", count: 58, state: "aborted_low_grade" },
        { lang: "ru", count: 100, state: "growing" },
        { lang: "ru", count: 2, state: "halted_by_moderator" },
        { lang: "ru", count: 3, state: "initial_prompt_review" },
        { lang: "ru", count: 1060, state: "prompt_lottery_waiting" },
        { lang: "ru", count: 7, state: "ranking" },
        { lang: "ru", count: 224, state: "ready_for_export" },
        { lang: "sv", count: 15, state: "growing" },
        { lang: "sv", count: 108, state: "initial_prompt_review" },
        { lang: "th", count: 22, state: "initial_prompt_review" },
        { lang: "tr", count: 9, state: "growing" },
        { lang: "tr", count: 43, state: "initial_prompt_review" },
        { lang: "tr", count: 4, state: "ready_for_export" },
        { lang: "uk-UA", count: 1, state: "aborted_low_grade" },
        { lang: "uk-UA", count: 101, state: "growing" },
        { lang: "uk-UA", count: 11, state: "initial_prompt_review" },
        { lang: "uk-UA", count: 95, state: "prompt_lottery_waiting" },
        { lang: "uk-UA", count: 9, state: "ready_for_export" },
        { lang: "vi", count: 6, state: "aborted_low_grade" },
        { lang: "vi", count: 101, state: "growing" },
        { lang: "vi", count: 232, state: "initial_prompt_review" },
        { lang: "vi", count: 30, state: "prompt_lottery_waiting" },
        { lang: "vi", count: 2, state: "ranking" },
        { lang: "vi", count: 3, state: "ready_for_export" },
        { lang: "zh", count: 69, state: "aborted_low_grade" },
        { lang: "zh", count: 101, state: "growing" },
        { lang: "zh", count: 88, state: "initial_prompt_review" },
        { lang: "zh", count: 173, state: "prompt_lottery_waiting" },
        { lang: "zh", count: 4, state: "ranking" },
        { lang: "zh", count: 69, state: "ready_for_export" },
      ],
    },
  },
};

export default {
  title: "Stats",
} as ComponentMeta<typeof Stats>;

export const Default = () => <Stats data={data} />;
