from easydict import EasyDict
import numpy as np
# set experiment configs
opt = EasyDict()

# load/output dir
opt.loadf = "./dump"
opt.outf = "./dump"

# normalize each data domain
# temporary not use each domain normalize!
opt.normalize_domain = False

# now it is half circle
opt.num_domain = 15
# opt.num_source = 8
# the specific source and target domain:
opt.source_domain = np.array([0, 12, 3, 4, 14, 8])
opt.num_source = opt.source_domain.shape[0]
opt.num_target = opt.num_domain - opt.num_source



opt.device = "cuda"
opt.seed = 2333
opt.num_epoch = 500
opt.batch_size = 10
opt.lr_d = 1e-4 #3e-5  # 1e-4
opt.lr_e = 1e-4
opt.lr_g = 1e-4
opt.load_g = False
# opt.lr_T = 1e-4
opt.gamma = 100
opt.beta1 = 0.9
opt.weight_decay = 5e-4
opt.wgan = False  # do not use wgan to train
opt.no_bn = True  # do not use batch normalization # True

# model size configs, used for D, E, F
opt.nx = 2  # dimension of the input data
opt.nt = 2  # dimension of the vertex embedding
opt.nh = 512  # dimension of hidden # 512
opt.nc = 2  # number of label class
opt.nd_out = 2 # dimension of D's output

# EF loss and -D loss balance
# this coefficient is inherit from the origin CIDA code
opt.lambda_gan = 0.5 # 0.5

# sample how many vertices for training D
opt.sample_v = 10

# # sample how many vertices for training G
opt.sample_v_g = 15

# drop out rate
opt.p = 0.2

opt.visualize = False

# dataset
opt.dataset = 'data/toy_d15_spiral_tight_boundary.pkl'