#!/bin/bash

#cd ../..

# custom config
DATA=~/efs/CoOp/data/
TRAINER=MaPLe

DATASET=$1
SEED=$2
MODEL=$3  # imagenet_21k/${TRAINER}_${TAG}/${CFG}_unc${UNC}_${SHOTS}shots
TAG=$4

#CFG=vit_b16_c2_ep50_batch32_16ctx
CFG=vit_b16_c2_ep100_batch32_16ctx
SHOTS=16

TESTMODEL=best_val

if [ ! $MODEL ]; then
  DIR=output/${DATASET}/${TRAINER}/${CFG}_${SHOTS}shots/seed${SEED}
  if [ -d "$DIR" ]; then
      echo "Results are available in ${DIR}."
  else
      echo "Run this job and save the output to ${DIR}"

      python train.py \
      --root ${DATA} \
      --seed ${SEED} \
      --trainer ${TRAINER} \
      --dataset-config-file configs/datasets/${DATASET}.yaml \
      --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
      --output-dir ${DIR} \
      TEST.FINAL_MODEL ${TESTMODEL} \
      DATASET.NUM_SHOTS ${SHOTS}
  fi
else
  DIR=output/${DATASET}/${TRAINER}_init_from_${TAG}/${CFG}_${SHOTS}shots/seed${SEED}
  if [ -d "$DIR" ]; then
      echo "Results are available in ${DIR}."
  else
      echo "Run this job and save the output to ${DIR}"

      python train.py \
      --root ${DATA} \
      --seed ${SEED} \
      --trainer ${TRAINER} \
      --dataset-config-file configs/datasets/${DATASET}.yaml \
      --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
      --output-dir ${DIR} \
      TEST.FINAL_MODEL ${TESTMODEL} \
      DATASET.NUM_SHOTS ${SHOTS} \
      MODEL.INIT_WEIGHTS output/${MODEL}/seed${SEED}/MultiModalPromptLearner/model-best.pth.tar
  fi
fi

# CUDA_VISIBLE_DEVICES=0 sh scripts/maple/main.sh imagenet 42 imagenet_21k_op/gMaPLe_tutorial_sampled_softmax/vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots imagenet_21k_op_gMaPLe_tutorial_sampled_softmax_vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots
# CUDA_VISIBLE_DEVICES=1 sh scripts/maple/main.sh my_cifar10 42 imagenet_21k_op/gMaPLe_tutorial_sampled_softmax/vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots imagenet_21k_op_gMaPLe_tutorial_sampled_softmax_vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots
# CUDA_VISIBLE_DEVICES=2 sh scripts/maple/main.sh my_cifar100 42 imagenet_21k_op/gMaPLe_tutorial_sampled_softmax/vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots imagenet_21k_op_gMaPLe_tutorial_sampled_softmax_vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots
# CUDA_VISIBLE_DEVICES=3 sh scripts/maple/main.sh food101 42 imagenet_21k_op/gMaPLe_tutorial_sampled_softmax/vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots imagenet_21k_op_gMaPLe_tutorial_sampled_softmax_vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots
# CUDA_VISIBLE_DEVICES=4 sh scripts/maple/main.sh stanford_cars 42 imagenet_21k_op/gMaPLe_tutorial_sampled_softmax/vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots imagenet_21k_op_gMaPLe_tutorial_sampled_softmax_vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots
# CUDA_VISIBLE_DEVICES=5 sh scripts/maple/main.sh fgvc_aircraft 42 imagenet_21k_op/gMaPLe_tutorial_sampled_softmax/vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots imagenet_21k_op_gMaPLe_tutorial_sampled_softmax_vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots
# CUDA_VISIBLE_DEVICES=6 sh scripts/maple/main.sh oxford_pets 42 imagenet_21k_op/gMaPLe_tutorial_sampled_softmax/vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots imagenet_21k_op_gMaPLe_tutorial_sampled_softmax_vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots
# CUDA_VISIBLE_DEVICES=7 sh scripts/maple/main.sh caltech101 42 imagenet_21k_op/gMaPLe_tutorial_sampled_softmax/vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots imagenet_21k_op_gMaPLe_tutorial_sampled_softmax_vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots
# CUDA_VISIBLE_DEVICES=0 sh scripts/maple/main.sh oxford_flowers 42 imagenet_21k_op/gMaPLe_tutorial_sampled_softmax/vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots imagenet_21k_op_gMaPLe_tutorial_sampled_softmax_vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots
# CUDA_VISIBLE_DEVICES=1 sh scripts/maple/main.sh eurosat 42 imagenet_21k_op/gMaPLe_tutorial_sampled_softmax/vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots imagenet_21k_op_gMaPLe_tutorial_sampled_softmax_vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots
# CUDA_VISIBLE_DEVICES=2 sh scripts/maple/main.sh dtd 42 imagenet_21k_op/gMaPLe_tutorial_sampled_softmax/vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots imagenet_21k_op_gMaPLe_tutorial_sampled_softmax_vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots

# CUDA_VISIBLE_DEVICES=3 sh scripts/maple/main.sh sun397 42 imagenet_21k_op/gMaPLe_tutorial_sampled_softmax/vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots imagenet_21k_op_gMaPLe_tutorial_sampled_softmax_vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots
# CUDA_VISIBLE_DEVICES=4 sh scripts/maple/main.sh ucf101 42 imagenet_21k_op/gMaPLe_tutorial_sampled_softmax/vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots imagenet_21k_op_gMaPLe_tutorial_sampled_softmax_vit_b16_c2_ep10_batch32_2ctx_cross_datasets_randaug2_unc1000_64shots