from src.utils import Instruction
from src.instructions import JudgeInstruction

instruction_dict_question = {
    "judge_system": Instruction(
        text="In the given question text, some parts are descriptions of physical system, while others are Initial conditions/ Approximate conditions/ Descriptions of solution objective. Descriptions of physical system includes: definitions of physical objects and their parameters (for example, a ball with mass 'm') , geometry constraints between objects (for example, three resistors are welded together to form a triangle). Your task is to judge the descriptions of physical system in the given improved question text consistent with the given original question text. Your judgement should follow the target steps:\n\n1.  **Identify the Descriptions of physical system **: You should identify and extract the descriptions of physical system from the given improved question text. Then, list each term of the descriptions one by one, for example “object: a ball with mass 'm'”, “geometry: two balls connected by a rope, along the vertical direction.”\n2.  **Analyze One-by-One**: Go through the descriptions of physical system one by one. Verify each directly in/extracted from/combinate by/consistent with the given original question text.\n3.  **Report Findings**:\n  – If all terms of descriptions of physical system are correct, state this.\n    - If you find an error, you MUST pinpoint the exact line or transition where the error occurs. Quote the incorrect part, explain the mistake (e.g., \" change the original descript of length of the rope\", \"Unnecessary introduce image charge as hints\", \"Conflict: the two balls are not on the same surface in original question\", etc.).\n4.  **Conclusion**: On the final line of your response, write **only** `Correct` if the derivation is flawless, or `Wrong` if you find any error.\n\n.",
        validator=JudgeInstruction.validator, formatter=JudgeInstruction.formatter
    ),
    "judge_initial": Instruction(
        text="In the given question text, some parts are Initial conditions, while others are Descriptions of physical system/ Approximate conditions/ Descriptions of solution objective. Initial conditions includes: initial statement of objects (for example, the planet orbits the center point at a uniform angular velocity 'omega' in circular motion), the initial external impact on the system (for example, striking the ball to generate an initial momentum 'P'). Your task is to judge the initial conditions in the given improved question text consistent with the given original question text. Your judgement should follow the target steps:\n\n1.  **Identify the initial conditions **: You should identify and extract the initial conditions from the given improved question text. Then, list each term of the initial conditions one by one, for example “initial distance between two balls is 'r'”, “initial momentum of the ball is 'P'”\n2.  **Analyze One-by-One**: Go through the descriptions of physical system one by one. Verify each directly in/extracted from/combinate by/consistent with the given original question text.\n3.  **Report Findings**:\n  – If all terms of initial conditions are correct, state this.\n    - If you find an error, you MUST pinpoint the exact line or transition where the error occurs. Quote the incorrect part, explain the mistake (e.g., \"Conflict: the magnetic field is not outward in original question\", etc.).\n4.  **Conclusion**: On the final line of your response, write **only** `Correct` if the derivation is flawless, or `Wrong` if you find any error.\n\n.",
        validator=JudgeInstruction.validator, formatter=JudgeInstruction.formatter
    ),
    "judge_approximate": Instruction(
        text="In the given question text, some parts are Approximate conditions, while others are Descriptions of physical system/ Initial conditions / Descriptions of solution objective. Approximate conditions includes: the order between different quantities (for example, mass of one object is far smaller than another), negligible quantities (for example, neglecting the electromagnetic field generated by electrons moving below light velocity in electrostatic field). Your task is to judge the approximate conditions in the given improved question text consistent with the given original question text. Your judgement should follow the target steps:\n\n1.  **Identify the Approximate conditions **: You should identify and extract the Approximate conditions from the given improved question text. Then, list each term of the initial conditions one by one, for example “m << M”, “assuming that A descends very slowly so that we can approximately consider the length of AB remains unchanged”\n2.  **Analyze One-by-One**: Go through the descriptions of physical system one by one. Verify each directly in/extracted from/combinate by/consistent with the given original question text.\n3.  **Report Findings**:\n  – If all terms of Approximate conditions are correct, state this.\n    - If you find an error, you MUST pinpoint the exact line or transition where the error occurs. Quote the incorrect part, explain the mistake (e.g., \"Conflict: the mass ‘m’ is non-negligible \", etc.).\n4.  **Conclusion**: On the final line of your response, write **only** `Correct` if the derivation is flawless, or `Wrong` if you find any error.\n\n.",
        validator=JudgeInstruction.validator, formatter=JudgeInstruction.formatter
    ),
    "judge_objective": Instruction(
        text="In the given question text, the final parts should be Descriptions of solution objective, while others are Descriptions of physical system/ Initial conditions / Approximate conditions. Descriptions of solution objective are the definition of solution objective and symbols should be used for the formula of solution objective (for example, solve the oscillation angle $\theta$, the answer should use symbols $\theta_0$, $x$, $x_0$). Your task is to judge the Descriptions of solution objective in the given improved question text consistent with the given original question text.\n If all terms of Approximate conditions are correct, state this.\n If you find an error, you MUST pinpoint the mistake symbols.\n**Conclusion**: On the final line of your response, write **only** `Correct` if the derivation is flawless, or `Wrong` if you find any error.\n\n",
        validator=JudgeInstruction.validator, formatter=JudgeInstruction.formatter
    )
}


instruction_dict_answer = {
    # "judge_dimension": Instruction(
    #     text="Carefully check the solution using dimensional analysis. Identify and specify any mistakes related to physical units or dimensions. In the last line, write only 'Correct' if there are no errors, or 'Wrong' if any errors are found.",
    #     validator=JudgeInstruction.validator, formatter=JudgeInstruction.formatter
    # ),
    "judge_formula": Instruction(
        text="In the given solution, some parts are derivations or calculations, while others DIRECTLY adopt / introduce original formulas / assumptions / theorems / principles / geometric relations / boundary conditions. Your task is to judge the mathematical derivation / calculation within the target step.\n\n1.  **Identify the Derivation**: Focus mainly on the equations inside the `\\[\\begin{ align} ... \\end{align}\\]` environment. You should not focus on the original formulas / assumptions / theorems / principles / geometric relations / boundary conditions stated within the `\\[\\boxed{ }\\]` environment.\n2.  **Analyze Step-by-Step**: Go through the derivation line by line. Verify each algebraic manipulation, substitution of variables from previous steps (as referenced by `\\label{ }` or `\\tag{ }`), and any numerical calculations.\n3.  **Report Findings**:\n    - If the entire derivation is mathematically sound, state this.\n    - If you find an error, you MUST pinpoint the exact line or transition where the error occurs. Quote the incorrect part, explain the mistake (e.g., \"algebraic error,\" \"incorrect substitution from tag{3},\" \"a sign was dropped\", etc.) and state what the correct derivation or result should be. Use the `label` or `tag` for reference if available.\n4.  **Conclusion**: On the final line of your response, write **only** `Correct` if the derivation is flawless, or `Wrong` if you find any mathematical error.\n\n**Example 1 (Correct Derivation):**\n*Step to review contains:* `\\[\\begin{align} ma &= F_{\\text{net}} \\nonumber \\ ma &= mg \\quad (\\text{using eq. \\ref{eq:net_force}}) \\nonumber \\ a &= g \\end{align}\\]`\n*Your review:*\nThe derivation begins by correctly substituting `F_net` with `mg` based on the reference to `eq:net_force`. The final step correctly isolates `a` by dividing both sides of `ma = mg` by `m`. The derivation is mathematically sound.\nCorrect\n\n**Example 2 (Incorrect Derivation):**\n*Step to review contains:* `\\[\\begin{align} \\frac{1}{2}mv_f^2 - \\frac{1}{2}mv_i^2 &= mgh \\label{eq:energy} \\tag{3} \\ v_f^2 - v_i^2 &= \\frac{1}{2}gh \\end{align}\\]`\n*Your review:*\nThe derivation starts from the work-energy theorem, referenced as tag{3}. In the transition from the first line to the second, the term `m` is canceled from the left side, but the right side is incorrectly divided by `2m` instead of just `m`. The correct second line should be `v_f^2 - v_i^2 = 2gh`. This is an algebraic error.\nWrong",
        validator=JudgeInstruction.validator, formatter=JudgeInstruction.formatter
    ),
    "judge_assumption": Instruction(
        text="In the given solution, some parts are derivations or calculations, while others DIRECTLY adopt / introduce original formulas / assumptions / theorems / principles / geometric relations / boundary conditions. Your task is to judge the original formulas / assumptions / theorems / principles / geometric relations / boundary conditions presented / stated in the target step.\n\n1.  **Identification**:  Mainly focus on statements within the `\\[\\boxed{ }\\]` environment along with other potential nature language statements in the provided step. \n2.  **Analyze its Validity**: Critically evaluate all the original formulas / assumptions / theorems / principles / geometric relations / boundary conditions based on the problem statement and the preceding (assumed correct) steps.\n    - Is it a factually correct statement of an original formula / assumption / theorem / principle / geometric relation / boundary condition in its general form?\n    - Is it an appropriate original formula / assumption / theorem / principle / geometric relation / boundary condition to apply at this specific stage of the problem?\n.   - Is it specifically valid for this problem according to the problem statement?\n   - Is it easily derived from more fundamental principles for this problem according to the problem statement, and therefore should not be used as an assumption?    - Is it specifically valid for this problem according to the problem statement?\n3.  **Report Findings**:\n    - If the original formula / assumption / theorem / principle / geometric relation / boundary condition is correctly stated and appropriately applied, state this clearly.\n    - If any original formula / assumption / theorem / principle / geometric relation / boundary condition is misstated (e.g., a sign error in the original formula) or inappropriately applied (e.g., using a non-relativistic formula in a relativistic problem) or not suitable as an assumption, you MUST clearly and concisely describe the error.\n4.  **Conclusion**: On the final line of your response, write **only** `Correct` if all the original formulas / assumptions / theorems / principles / geometric relations / boundary conditions are valid and correctly applied, or `Wrong` if there is any error.\n\n**Example 1 (Correct Application):**\n*Step to review contains:* `\\[\\boxed{F_{\\text{net}} = ma}\\]` *for a dynamics problem.*\n*Your review:*\nThe principle stated in the boxed environment is `F_net = ma`, which is Newton's Second Law of Motion. This is a fundamental and correct principle for analyzing the dynamics of a massive object. Its application is appropriate for this step.\nCorrect\n\n**Example 2 (Incorrect Application):**\n*Problem involves a block on a 30-degree incline. Step to review contains:* `\\[\\boxed{N = mg}\\]` *where N is the normal force.*\n*Your review:*\nThe principle stated is `N = mg`. While this correctly relates normal force to gravitational force for an object on a horizontal surface, it is incorrectly applied here. In this specific problem, for a block on an inclined plane at an angle `θ`, the correct relation for the normal force is `N = mg \\cos\\theta`. The assumption is therefore wrong for the given geometric conditions.\nWrong",
        validator=JudgeInstruction.validator, formatter=JudgeInstruction.formatter
    )
}
