# 📁 File Structure

* **figure**: Visualization files
* **log**: Records of each experiment
* **result**: Experimental results
* **simulated\_data**: Data files

# 🚀 Running Example

* **Generating data**: `bash data_generator.sh`
* **Run algorithm**: `bash exp_comp_run.sh`
* **Process results**: `python result_process.py`
* **Visualize**: `python draw.py` 

# 📦 Required Packages

* `numpy`
* `pandas`
* `torch`
* `matplotlib`
* `causalnex`

# 🧪 Experiment Information

## 1. Evaluation of Overall Performance (Filename: comp)
This experiment aims to evaluate overall performance. **Regarding structural information**, the experiment covers scenarios with 10, 20, 30, and 50 nodes, edge multipliers of 2 and 4, noise types including Gaussian (gauss) and exponential (exp), a fixed lag order of 3, and experiments were repeated for 6 different structures. **Regarding data information**, two datasets with 250 and 1000 data points were used. **Regarding prior information**, a prior rate of 0.8 was set, with no duplicate priors. **Regarding algorithm information**, this includes DYNOTEARS, DYNOTEARS& (Init 0), DYNOTEARS& (Init Data), DYNOTEARS\* (Init 0), and DYNOTEARS\* (Init Data), with an edge existence weight set to 0.5 and an edge threshold of 0.1.

## 2. Impact of Initialization Strategies on Stability (Filename: init)
This experiment focuses on the impact of initialization strategies on stability. **Regarding structural information**, it was set to 30 nodes, edge multipliers of 2 and 4, Gaussian (gauss) and exponential (exp) noise types, and a lag order of 3, with no repeated structures. **Regarding data information**, datasets with 250 and 1000 data points were used. **Regarding prior information**, the prior rate was 0.8, with no duplicate priors. **Regarding algorithm information**, this includes DYNOTEARS, DYNOTEARS& (Init 0), DYNOTEARS& (Init Data), DYNOTEARS\* (Init 0), and DYNOTEARS\* (Init Data), with an edge existence weight of 0.5 and an edge threshold of 0.1. Notably, each algorithm was run 12 times under the same initialization conditions.

## 3. Max Comparison Experiment (Filename: max)
This experiment conducts a max comparison. **Regarding structural information**, it includes 30 nodes, edge multipliers of 2 and 4, Gaussian (gauss) and exponential (exp) noise types, a lag order of 3, and was repeated for 6 structures. **Regarding data information**, datasets with 250 and 1000 data points were used. **Regarding prior information**, a prior rate of 0.8 was set, with no duplicate priors. **Regarding algorithm information**, this includes DYNOTEARS, DYNOTEARS^ (Init 0), DYNOTEARS^ (Init Data), DYNOTEARS& (Init 0), DYNOTEARS& (Init Data), DYNOTEARS\* (Init 0), and DYNOTEARS\* (Init Data), with an edge existence weight of 0.5 and an edge threshold of 0.1.

## 4. Real Data (Filename: dream4)
This experiment uses real data for evaluation. **Regarding structural information**, there are 100 nodes, and five repeated structures were used. **Regarding data information**, this includes training set sizes of 63, 126, 189, and a test set size of 21. **Regarding prior information**, prior rates of 0.25, 0.5, 0.75, and 1.0 were covered, with no duplicate priors. **Regarding algorithm information**, this includes NOTEARS, NOTEARS+edge, DYNOTEARS, DYNOTEARS& (Init 0), DYNOTEARS& (Init Data), DYNOTEARS\* (Init 0), and DYNOTEARS\* (Init Data), with an edge existence weight set to 0.5 and an edge threshold of 0.1.

## 5. Evaluation on Nonlinear Data (Filename: nonlinear)
This experiment evaluates algorithm performance on nonlinear data. **Regarding structural information**, it was set to 20 nodes, an edge multiplier of 4, Gaussian (gauss) noise type, a lag order of 3, and was repeated for 6 structures. **Regarding data information**, datasets with 200 and 1000 data points were used. **Regarding prior information**, a prior rate of 0.8 was set, with no duplicate priors. **Regarding algorithm information**, this includes NTSDYNOTEARS and NTSDYNOTEARS\*, with an edge existence weight of 0.5 and an edge threshold of 0.3.

## 6. Evaluation of Lag-Agnostic Edge Absence Constraints (Filename: absence)
This experiment aims to evaluate eedge aabsence constraints. **Regarding structural information**, the experiment covers scenarios with 20, 30, and 50 nodes, edge multipliers of 2 and 4, noise types including Gaussian (gauss) , a fixed lag order of 3, and experiments were repeated for 6 different structures. **Regarding data information**, two datasets with 250 and 1000 data points were used. **Regarding prior information**, a prior rate of 0.8 was set, with no duplicate priors. **Regarding algorithm information**, this includes DYNOTEARS, DYNOTEARS+absence, DYNOTEARS& (Init 0), DYNOTEARS& (Init Data), DYNOTEARS\* (Init 0), and DYNOTEARS\* (Init Data), with an edge existence weight set to 0.5 and an edge threshold of 0.1.

## 7. Evaluation under Varying Prior Rates (Filename: prior)
This experiment evaluates algorithm performance under varying prior rates. **Regarding structural information**, it includes 30 nodes, edge multipliers of 2 and 4, Gaussian (gauss) and exponential (exp) noise types, a lag order of 3, and was repeated for 6 structures. **Regarding data information**, datasets with 250 and 1000 data points were used. **Regarding prior information**, prior rates of 0.2, 0.4, 0.6, 0.8, and 1.0 were used, with no duplicate priors. **Regarding algorithm information**, this includes DYNOTEARS, DYNOTEARS& (Init 0), DYNOTEARS& (Init Data), DYNOTEARS\* (Init 0), and DYNOTEARS\* (Init Data), with an edge existence weight of 0.5 and an edge threshold of 0.1.

## 8. Evaluation with Varying Maximum Lag Numbers (Filename: lag)
This experiment evaluates algorithm performance with varying maximum lag numbers. **Regarding structural information**, it was set to 30 nodes, edge multipliers of 2 and 4, Gaussian (gauss) and exponential (exp) noise types, with lag orders varying from 1 to 10 (1, 2, 3, 4, 5, 6, 7, 8, 9, 10), and was repeated for 6 structures. **Regarding data information**, datasets with 250 and 1000 data points were used. **Regarding prior information**, prior rates of 0.2, 0.4, 0.6, 0.8, and 1.0 were used, with no duplicate priors. **Regarding algorithm information**, this includes DYNOTEARS, DYNOTEARS& (Init 0), DYNOTEARS& (Init Data), DYNOTEARS\* (Init 0), and DYNOTEARS\* (Init Data), with an edge existence weight of 0.5 and an edge threshold of 0.1.

## 9. Evaluation with Varying Prior Loss Weights (Filename: weight)
This experiment evaluates algorithm performance with varying prior loss weights. **Regarding structural information**, it includes 30 nodes, edge multipliers of 2 and 4, Gaussian (gauss) and exponential (exp) noise types, a lag order of 3, and was repeated for 6 structures. **Regarding data information**, datasets with 250 and 1000 data points were used. **Regarding prior information**, a prior rate of 0.8 was set, with no duplicate priors. **Regarding algorithm information**, this includes DYNOTEARS, DYNOTEARS& (Init 0), DYNOTEARS& (Init Data), DYNOTEARS\* (Init 0), and DYNOTEARS\* (Init Data), with edge existence weights of 0.01, 0.1, 0.5, 1, 5, 10, and an edge threshold of 0.1.

## 10. Evaluation under Larger Maximum Lags than Ground Truth (Filename: larger_lag)
This experiment evaluates the scenario where the set maximum lag is greater than the true lag. **Regarding structural information**, it was set to 30 nodes, an edge multiplier of 2, Gaussian (gauss) noise type, a true lag order of 5, and involved no repeated structures. **Regarding data information**, a dataset with 1000 data points was used. **Regarding prior information**, the prior rate was 0.8, with no duplicate priors. **Regarding algorithm information**, this includes DYNOTEARS, DYNOTEARS& (Init 0), DYNOTEARS& (Init Data), DYNOTEARS\* (Init 0), and DYNOTEARS\* (Init Data), with an edge existence weight of 0.5 and an edge threshold of 0.1. The lag parameter for the algorithms was set to 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 in the experiment.

## 11. Visualization of Lag-Specific Edge Weights (Filename: visualization)
This experiment aims to visualize lag-specific edge weights. **Regarding structural information**, it was set to 5 nodes, an edge multiplier of 5, Gaussian (gauss) noise type, a lag order of 3, and involved no repeated structures. **Regarding data information**, a dataset with 1000 data points was used. **Regarding prior information**, the prior rate was 0.6, with no duplicate priors. **Regarding algorithm information**, this includes DYNOTEARS, DYNOTEARS& (Init 0), DYNOTEARS& (Init Data), DYNOTEARS\* (Init 0), and DYNOTEARS\* (Init Data), with an edge existence weight of 0.5 and an edge threshold of 0.1.