if [ $# -eq 0 ]; then
    echo "error: you must input algorithm"
    exit 1
fi

algorithm="$1"
data_root="simulated_data_prior/simulated_data_${algorithm}"
repeat_num=1
node_num_list=(20)
p_orders_list=(3)
T_list=(1000 200)
edge_ratio_list=(2 4)
nt_list=('gauss' 'exp')
LOG_DIR="log" 

mkdir -p "$LOG_DIR"
TIMESTAMP=$(date +'%Y%m%d_%H%M%S')
LOG_FILE="${LOG_DIR}/exp_prior_${algorithm}_${TIMESTAMP}.log"

echo "Starting train for algorithm: $algorithm"
echo "Starting train..."
for noises_type in "${nt_list[@]}"; do
    for node_num in "${node_num_list[@]}"; do
        for edge_ratio in "${edge_ratio_list[@]}"; do
            edge_num=$((edge_ratio * node_num)) 
            for p_orders in "${p_orders_list[@]}"; do
                for T in "${T_list[@]}"; do
                    echo "Running with: node_num=$node_num, edge_num=$edge_num, p_orders=$p_orders, T=$T"
                    # python exp_prior.py --data_root "$data_root" --repeat_num "$repeat_num" --node_num "$node_num" --edge_num "$edge_num" --p_orders "$p_orders" --T "$T" --algorithm "$algorithm" --noises_type "$noises_type" --edge_probs 0.01 0.05 0.10 0.30 0.50 >> "$LOG_FILE" 2>&1
                    python exp_prior.py --data_root "$data_root" --repeat_num "$repeat_num" --node_num "$node_num" --edge_num "$edge_num" --p_orders "$p_orders" --T "$T" --algorithm "$algorithm" --noises_type "$noises_type" --edge_probs 0.05 0.10 0.30 0.50 >> "$LOG_FILE" 2>&1
                    # python exp_prior.py --data_root simulated_data_prior/simulated_data_lag_0 --repeat_num 1 --node_num 20 --edge_num 80 --p_orders 3 --T 1000 --algorithm lag_0 --noises_type gauss --edge_probs 0.05 >> "$LOG_FILE" 2>&1

                    if [ $? -ne 0 ]; then
                        echo "Error running command for T=$T. Check logs or script output."
                    fi
                    echo "----------------------------------------" # Separator for clarity
                done
            done
        done
    done
done

echo "Train finished."