#!/bin/bash

#  -e ，，
set -e

echo "========================================"
echo "       Edgeexist       "
echo "========================================"

# ====================  ====================
# 
DATA_PATH="Brownian_data"
RESULTS_BASE_PATH="results"

# 
GT_List=(BA ER)
DIM_List=(2D 1D)
T_List=(1000 5000)

SEEDS=(1)

EDGE_PENALTIES=(0.1)
PRIOR_RATES=(0.0 0.05 0.1 0.3 0.5)
PENALTY_VALUES=(1e-8)
THRESHOLD_VALUES=(0.5)
# =================================================================

# 
mkdir -p "$RESULTS_BASE_PATH"

# 
for GT in "${GT_List[@]}"
do
    for DIM in "${DIM_List[@]}"
    do
        for T in "${T_List[@]}"
        do
            # ---  ---
            DATA_PREFIX="Brownian_${DIM}_${GT}"
            RESULTS_CSV="${RESULTS_BASE_PATH}/Brownian_${GT}_${DIM}_${T}.csv"

            # DIMKE
            if [ "$DIM" == "1D" ]; then
                K=2
                E=3
            elif [ "$DIM" == "2D" ]; then
                K=4
                E=3
            else
                echo ":  '$DIM'"
                exit 1
            fi
            
            echo -e "\n\n################################################################"
            echo ": GT=$GT, DIM=$DIM, T=$T, K=$K, E=$E"
            echo ": $DATA_PREFIX"
            echo ": $RESULTS_CSV"
            echo "################################################################"

            # ，，
            # rm -f "$RESULTS_CSV" # ，

            for seed_v in "${SEEDS[@]}"
            do
                echo -e "[]  seed=$seed_v ..."
            
                for threshold in "${THRESHOLD_VALUES[@]}"
                do
                    for edge_pnt_v in "${EDGE_PENALTIES[@]}"
                    do
                        for prior_rate_v in "${PRIOR_RATES[@]}"
                        do
                            for pnt_v in "${PENALTY_VALUES[@]}"
                            do 
                                #  edge_pnt  0， prior_rate ，
                                if [ $(echo "$edge_pnt_v == 0" | bc) -eq 1 ] && [ $(echo "$prior_rate_v != ${PRIOR_RATES[0]}" | bc) -eq 1 ]; then
                                    echo "     -> :  edge_pnt  0 , prior_rate ."
                                    continue
                                fi
                                
                                echo -e "\n  -> : pnt=$pnt_v, edge_pnt=$edge_pnt_v, prior_rate=$prior_rate_v, seed=$seed_v, threshold=$threshold"
                                
                                python run_single_trial.py \
                                    --pnt "$pnt_v" \
                                    --K "$K" \
                                    --E "$E" \
                                    --T "$T" \
                                    --rdseeds "$seed_v" \
                                    --edge_pnt "$edge_pnt_v" \
                                    --prior_rate "$prior_rate_v" \
                                    --data_path "$DATA_PATH" \
                                    --data_file_prefix "$DATA_PREFIX" \
                                    --results_csv "$RESULTS_CSV" \
                                    --threshold "$threshold"

                                echo "  -> 。"
                            done
                        done
                    done
                done
            done
        done
    done
done

echo -e "\n========================================"
echo "       ！         "
echo "   '$RESULTS_BASE_PATH' 。"
echo "========================================"