#!/bin/bash

# Ensure the script is run from the directory where exp_nonlinear.py is located
# or adjust the python script path accordingly.
# Assuming exp_nonlinear.py is in the same directory as this shell script.

BASE_DIR=$(dirname "$0")
cd "$BASE_DIR" || exit

echo "Starting nts_notears..."
nohup python -u exp_nonlinear.py --algorithms nts_notears > nts_notears.log 2>&1 &
NTS_NOTEARS_PID=$!
echo "nts_notears started with PID $NTS_NOTEARS_PID. Log: nts_notears.log"

echo "Starting nts_notears_multiply..."
nohup python -u exp_nonlinear.py --algorithms nts_notears_multiply > nts_notears_multiply.log 2>&1 &
NTS_NOTEARS_MULTIPLY_PID=$!
echo "nts_notears_multiply started with PID $NTS_NOTEARS_MULTIPLY_PID. Log: nts_notears_multiply.log"

echo "Starting nts_notears_and..."
nohup python -u exp_nonlinear.py --algorithms nts_notears_and > nts_notears_and.log 2>&1 &
NTS_NOTEARS_AND_PID=$!
echo "nts_notears_and started with PID $NTS_NOTEARS_AND_PID. Log: nts_notears_and.log"

echo "All algorithms started in the background."
echo "PIDs: nts_notears ($NTS_NOTEARS_PID), nts_notears_multiply ($NTS_NOTEARS_MULTIPLY_PID), nts_notears_and ($NTS_NOTEARS_AND_PID)" 