node_num_list=(5)
edge_num_list=(5)
p_orders_list=(3)
nt_list=('gauss' 'exp')
LOG_DIR="log" 

mkdir -p "$LOG_DIR"
TIMESTAMP=$(date +'%Y%m%d_%H%M%S')
LOG_FILE="${LOG_DIR}/data_generation_${TIMESTAMP}.log"

# Iterate through all combinations of parameters
echo "Starting data generation..."

for noises_type in "${nt_list[@]}"; do
    for node_num in "${node_num_list[@]}"; do
        for edge_num in "${edge_num_list[@]}"; do
            for p_orders in "${p_orders_list[@]}"; do
                echo "Running with: node_num=$node_num, edge_num=$edge_num, p_orders=$p_orders, noises_type=$noises_type"
                python data_generator.py --node_num "$node_num" --edge_num "$edge_num" --p_orders "$p_orders" --noises_type "$noises_type">> "$LOG_FILE"
                if [ $? -ne 0 ]; then
                    echo "Error running command for T=$T. Check logs or script output."
                fi
                echo "----------------------------------------" # Separator for clarity
            done
        done
    done
done

echo "Data generation finished."