

# mujoco 210
export MUJOCO_GL=egl
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$HOME/.mujoco/mujoco210/bin

# set up cuda 
export CUDA_DEVICE_ORDER=PCI_BUS_ID


# run training on 5 random seeds
overrides=cartpole_swingup
# overrides=cartpole_balance
# overrides=walker_stand
# overrides=walker_walk
# overrides=quadruped_walk
# overrides=quadruped_run
# overrides=humanoid_stand
# overrides=humanoid_walk

cuda_id=0
for seed in 12345 23451 34512 45123 51234; do
    # set up cuda
    export CUDA_VISIBLE_DEVICES=${cuda_id}
    cuda_id=$(($cuda_id+1))
    # train
    python train.py \
        overrides=${overrides} \
        seed=${seed} \
        agent.params.robust_method=l2_adv_param \
        agent.params.robust_coef=1e-4 \
        experiment=adv &
done

