

# mujoco 210
export MUJOCO_GL=egl
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$HOME/.mujoco/mujoco210/bin

# set up cuda 
export CUDA_DEVICE_ORDER=PCI_BUS_ID

# overrides=a1_ls
overrides=a1_ftl

task_name=reset
task_name=stand
# task_name=sit

# non robust
robust_method=none
robust_coef=0.0
exp_name=default

# # l2 adv
# robust_method=l2_adv_param
# robust_coef=1e-4
# exp_name=adv_lr1e-4

cuda_id=4
# for seed in 12345 23451 34512 45123 51234; do
for seed in 12345; do
    # set up cuda
    export CUDA_VISIBLE_DEVICES=${cuda_id}
    cuda_id=$(($cuda_id+1))
    # train
    python train.py \
        overrides=${overrides} \
        seed=${seed} \
        agent.params.robust_method=${robust_method} \
        agent.params.robust_coef=${robust_coef} \
        env.params.task_name=${task_name} \
        experiment=${overrides}_${task_name}-${exp_name}
done


