conda activate vllm

ROOT=/root/
DATA=$ROOT/data/

cd $ROOT

OUTPUT_DIR=./results/general/
mkdir -p $OUTPUT_DIR

for MODEL_SIZE in 7B 1.5B; do
  MODEL_NAME=Qwen2.5-Math-${MODEL_SIZE}
  MODEL_PATH=/${MODEL_NAME}
  TEMPLATE=qwen

  CUDA_VISIBLE_DEVICES=4,5,6,7 python eval_scripts/eval_general.py \
    --model_path $MODEL_PATH \
    --input_path $DATA \
    --output_path $OUTPUT_DIR/$MODEL_NAME.jsonl \
    --remove_system True \
    --template $TEMPLATE > $OUTPUT_DIR/$MODEL_NAME-general.log
done