conda activate vllm

ROOT=/root/
DATA=$ROOT/data/

cd $ROOT

OUTPUT_DIR=./results/math/
mkdir -p $OUTPUT_DIR

for MODEL_SIZE in 7B 1.5B; do
  MODEL_NAME=Qwen2.5-Math-${MODEL_SIZE}
  MODEL_PATH=/${MODEL_NAME}
  TEMPLATE=qwen

  CUDA_VISIBLE_DEVICES=0,1,2,3 python eval_scripts/generate_vllm.py \
    --model_path $MODEL_PATH \
    --input_file $DATA \
    --remove_system True \
    --add_oat_evaluate True \
    --output_file $OUTPUT_DIR/$MODEL_NAME.jsonl \
    --template $TEMPLATE > $OUTPUT_DIR/$MODEL_NAME.log
done