import json
import os

from src.tools.path_utils import get_default_results_directory, get_root_directory


def get_cost(pipeline, strong_model, weak_model):
    merged_results_dir = f"{get_default_results_directory()}/{pipeline.config.name}/merged_results/{strong_model}+{weak_model}"
    os.makedirs(merged_results_dir, exist_ok=True)
    with open(
        f"{merged_results_dir}/cost.json",
        "w",
    ) as f:
        json.dump(pipeline.cost, f, indent=2)

    print(pipeline.cost)
