# ctrl


## Setup
Make sure you have Python installed on your machine.
```bash
python -m venv venv
pip install -r requirements.txt
pip install -e .
```

For development we use pre-commit hooks. To install pre-commit hooks, run the following command.
```bash
pre-commit install
pre-commit run --all-files
```

Next we need to install APPS dataset. Run the following command to download the dataset.

```bash
mkdir data
curl https://people.eecs.berkeley.edu/~hendrycks/APPS.tar.gz -o data/APPS.tar.gz
tar -xvf data/APPS.tar.gz -C data/
```

### Test different protocols


#### Trusted Monitoring
```bash
python -m src.experiments.five_shot
```

#### Task Decomposition
```bash
python -m src.experiments.task_decomposition
```
