# -*- coding: utf-8 -*-
"""AverageCaseInputData.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1MPYTkUKRBbqspEUTOi1sFlsRU9uHC9MG
"""

import numpy as np

def counter_example_samples(eps, n, d=3):
  ''' must have d > = 3 '''
  assert d >= 3
  #basis
  V = np.eye(d, d)

  u = eps * V[1] + np.sqrt(1-eps**2) * V[2]

  # basis for the first subspace
  T1_basis = [V[0].T, u.T]
  for i in range(3, d):
    T1_basis.append(V[i].T)

  W1 = np.column_stack(T1_basis)
  Z1 = np.random.normal(size=(n, d-1))/np.sqrt(d-1)
  X1 = np.matmul(Z1, W1.T)

  # basis for the second task subspace
  W2 = V[2].reshape((d, 1))
  Z2 = np.random.normal(size=(n, 1))
  X2 = np.matmul(Z2, W2.T)

  w_star = np.zeros((d, 1))
  w_star[1] = 1
  w_star[2:d] = 1/(d-2)
  w_star = w_star / np.linalg.norm(w_star)


  Y1 = np.matmul(X1, w_star).reshape((n, 1))
  Y2 = np.matmul(X2, w_star).reshape((n, 1))

  return (X1, Y1), (X2, Y2)