import matplotlib.pyplot as plt
import pickle
import numpy as np
import seaborn as sns
sns.set_theme(style="white")


up = np.load('npy/bc_0.npy')
down = np.load('npy/bc_1.npy')
plt.subplot(2, 1, 1)
plt.tick_params(left=False,
                bottom=False,
                labelleft=False,
                labelbottom=False)
for lol in range(47):
    plt.plot(up[0, lol, 0, 0], up[0, lol, 0, 1], 'bo', alpha=0.2 + 0.01*lol)
    plt.plot(up[0, lol, 1, 0], up[0, lol, 1, 1], 'ro', alpha=0.2 + 0.01*lol)
    plt.plot(up[0, lol, 2, 0], up[0, lol, 2, 1], 'go', alpha=0.2 + 0.01*lol)

    plt.plot(down[0, lol, 0, 0], down[0, lol, 0, 1], 'bo', alpha=0.2 + 0.01*lol)
    plt.plot(down[0, lol, 1, 0], down[0, lol, 1, 1], 'ro', alpha=0.2 + 0.01*lol)
    plt.plot(down[0, lol, 2, 0], down[0, lol, 2, 1], 'go', alpha=0.2 + 0.01*lol)

plt.plot(up[0, lol, 0, 0], up[0, lol, 0, 1], 'bo', label = 'Agent 1')
plt.plot(up[0, lol, 1, 0], up[0, lol, 1, 1], 'ro', label = 'Agent 2')
plt.plot(up[0, lol, 2, 0], up[0, lol, 2, 1], 'go', label = 'Agent 3')

plt.plot(down[0, lol, 0, 0], down[0, lol, 0, 1], 'bo')
plt.plot(down[0, lol, 1, 0], down[0, lol, 1, 1], 'ro')
plt.plot(down[0, lol, 2, 0], down[0, lol, 2, 1], 'go')
plt.ylim([-2.5, 2.5])
plt.xlim([-2.5, 2.5])
plt.xlabel("DNRI")
plt.legend(bbox_to_anchor=(0, 1, 1, 0), loc="lower left", mode="expand", ncol=3)

plt.subplot(2, 1, 2)
plt.tick_params(left=False,
                bottom=False,
                labelleft=False,
                labelbottom=False)
up = np.load('npy/up.npy')
down = np.load('npy/down.npy')

for lol in range(47):
    plt.plot(up[0, lol, 0, 0], up[0, lol, 0, 1], 'bo', alpha=0.2 + 0.01*lol)
    plt.plot(up[0, lol, 1, 0], up[0, lol, 1, 1], 'ro', alpha=0.2 + 0.01*lol)
    plt.plot(up[0, lol, 2, 0], up[0, lol, 2, 1], 'go', alpha=0.2 + 0.01*lol)

    plt.plot(down[0, lol, 0, 0], down[0, lol, 0, 1], 'bo', alpha=0.2 + 0.01*lol)
    plt.plot(down[0, lol, 1, 0], down[0, lol, 1, 1], 'ro', alpha=0.2 + 0.01*lol)
    plt.plot(down[0, lol, 2, 0], down[0, lol, 2, 1], 'go', alpha=0.2 + 0.01*lol)

plt.plot(up[0, lol, 0, 0], up[0, lol, 0, 1], 'bo', label = 'Agent 1')
plt.plot(up[0, lol, 1, 0], up[0, lol, 1, 1], 'ro', label = 'Agent 2')
plt.plot(up[0, lol, 2, 0], up[0, lol, 2, 1], 'go', label = 'Agent 3')

plt.plot(down[0, lol, 0, 0], down[0, lol, 0, 1], 'bo')
plt.plot(down[0, lol, 1, 0], down[0, lol, 1, 1], 'ro')
plt.plot(down[0, lol, 2, 0], down[0, lol, 2, 1], 'go')
plt.ylim([-2.5, 2.5])
plt.xlim([-2.5, 2.5])
plt.xlabel("SS-MAIL")
# plt.legend(loc='upper left')
plt.show()


# plt.savefig('filename.png')