import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns
sns.set_theme(style="white")

bc = np.load('bc.npy')
ssgail = np.load('ssgail.npy')

standard_dev = np.ones(48)*0.01

vals = np.zeros((10,5))
# 1, 10, 15, 20,       25, 30, 50, 70,        90, none (110)
vals[0] = np.array([2.622417, 23.741258, 18.107328, 58.577321, 43.225268])
vals[1] = np.array([4.613080, 3.316223, 1.644701, 3.143745, 2.015813])
vals[2] = np.array([2.179670, 3.583340, 3.124634, 2.492759, 2.427675])
vals[3] = np.array([3.398115, 2.016785, 1.865008, 5.148788, 1.443444])

vals[4] = np.array([3.137285, 5.246099, 3.833141, 4.204453, 2.023512])
vals[5] = np.array([5.189550, 6.457410, 4.482973, 3.341366, 1.916671])
vals[6] = np.array([3.313593, 5.462413, 4.957292, 3.198008, 4.196067])
vals[7] = np.array([3.897390, 3.825473, 4.489655, 8.987879, 2.254833])

vals[8] = np.array([2.168131, 3.148287, 7.134661, 8.449990, 4.000479])
vals[9] = np.array([3.832677, 7.016762, 3.934630, 12.258527, 3.686560])

# print(vals.mean(axis=-1))
mean_vals = vals.mean(axis=-1)
standard_dev = vals.std(axis=-1)
lower_err = vals.min(axis=-1)*0.5
upper_err = vals.max(axis=-1)*0.5
x= np.array([1, 10, 15, 20, 25, 30, 50, 70, 90, 110])
plt.xlabel('Trajectory Forcing Percentage')
plt.ylabel('Compounding Errors')
plt.plot(x, mean_vals, color='#489bee', marker='o', ms=2, label='Mean of Errors')
# plt.plot(np.arange(48), ssgail, color='#9D2EC5', marker='o', ms=2, label='MAIL')
plt.errorbar(x, mean_vals, standard_dev, linestyle='None', alpha = 0.2,  color='#489bee', label='Std of Errors')
# plt.errorbar(x, mean_vals, [lower_err, upper_err], linestyle='None', alpha = 0.5,  color='#489bee')
plt.fill_between(x, mean_vals-standard_dev, mean_vals+standard_dev, alpha = 0.1, color='#489bee')
# plt.fill_between(range(48), ssgail-standard_dev, ssgail+standard_dev, alpha = 0.25, color='#9D2EC5')
plt.ylim([0, 10])
plt.xlim([0, 100])
plt.legend(loc='lower right')
plt.show()