import numpy as np
import matplotlib.pyplot as plt
import os
import re
import seaborn as sns
sns.set_theme(style="white")
from scipy.ndimage.filters import gaussian_filter1d


file_index = -1
files_to_open = os.listdir("./data/neg/")
# regex_score = r'BEST VAL LOSS:    ([\d]+).([\d]+)'
regex_score = r'CURRENT VAL LOSS: ([\d]+).([\d]+)'
y = np.zeros((5,150))
for file_to_open in files_to_open:
    print(file_to_open)
    if "out" not in file_to_open:
        continue
    file_index += 1
    figure, axis = plt.subplots(1,1)
    x_green = []
    x_yellow = []
    y_green = []
    y_yellow = []
    prev_score = 0
    step=0
    
    
    
    with open("./data/neg/" + file_to_open) as f:
        time_limit_breaker = True
        time_in_sec = 0

        for line in f:
            result_score = re.findall(regex_score, line)

            if len(result_score) !=0:
                print(file_index,float(result_score[0][0])+float(result_score[0][1])*10**-6)
                y[file_index, step] -= float(result_score[0][0])+float(result_score[0][1])*10**-6
                step +=1

file_index = -1
files_to_open = os.listdir("./data/pos/")
# regex_score = r'BEST VAL LOSS:    ([\d]+).([\d]+)'
y_p = np.zeros((5,150))
for file_to_open in files_to_open:
    print(file_to_open)
    if "out" not in file_to_open:
        continue
    file_index += 1
    figure, axis = plt.subplots(1,1)
    x_green = []
    x_yellow = []
    y_green = []
    y_yellow = []
    prev_score = 0
    step=0
    
    
    
    with open("./data/pos/" + file_to_open) as f:
        time_limit_breaker = True
        time_in_sec = 0

        for line in f:
            result_score = re.findall(regex_score, line)

            if len(result_score) !=0:
                print(file_index,float(result_score[0][0])+float(result_score[0][1])*10**-6)
                y_p[file_index, step] -= float(result_score[0][0])+float(result_score[0][1])*10**-6
                step +=1

print(y_p[:,-5:])
# # spl = make_interp_spline(np.arange(150), y.mean(axis=0), k=11)
y = gaussian_filter1d(y, sigma=1) #spl(np.linspace(0, 150, 1000) )
# # spl_p = make_interp_spline(np.arange(150), y_p.mean(axis=0), k=11)
y_p = gaussian_filter1d(y_p, sigma=1)#spl_p(np.linspace(0, 150, 1000) )



plt.xlabel('Epochs')
plt.ylabel('Training Error')
plt.plot(np.arange(150), y.mean(axis=0), color='#489bee', marker='o', ms=0, linewidth=1, label='Positive & Negative')
plt.fill_between(np.arange(150), y.mean(axis=0)-y.std(axis=0), y.mean(axis=0)+y.std(axis=0), alpha = 0.2, color='#489bee')
plt.plot(np.arange(150), y_p.mean(axis=0), color='#9D2EC5', marker='o', ms=0,linewidth=1, label='Positive Only')
plt.fill_between(np.arange(150), y_p.mean(axis=0)-y_p.std(axis=0), y_p.mean(axis=0)+y_p.std(axis=0), alpha = 0.2, color='#9D2EC5')
# plt.ylim([-60, 0])
plt.xlim([0, 150])
plt.legend(loc="lower right")
plt.show()