import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns
sns.set_theme(style="white")

bc = np.zeros((5,48))
for i in range(1,6):
    bc[i-1] = np.load('bc'+str(i)+'.npy')
ssgail = np.zeros((5,48))
for i in range(1,6):
    ssgail[i-1] = np.load('ssgail'+str(i)+'.npy')

print(bc.shape)
plt.xlabel('Timesteps')
plt.ylabel('Compounding Errors')
plt.plot(np.arange(48), bc.mean(axis=0), color='#489bee', marker='o', ms=1, label='DNRI')
plt.fill_between(range(48), bc.mean(axis=0)-bc.std(axis=0), bc.mean(axis=0)+bc.std(axis=0), alpha = 0.2, color='#489bee')
plt.plot(np.arange(48), ssgail.mean(axis=0), color='#9D2EC5', marker='o', ms=1, label='SS-MAIL')
plt.fill_between(range(48), ssgail.mean(axis=0)-ssgail.std(axis=0), ssgail.mean(axis=0)+ssgail.std(axis=0), alpha = 0.2, color='#9D2EC5')
plt.xlim([0,47])
plt.legend()
plt.show()