# Import Python packages.
from typing import Any, Dict, List, Mapping, Sequence, Tuple

# Import developing packages.
import fin_tech_py_toolkit as lib


def prepare(
    name: str, prefix: str, suffix: str, /  # noqa: W504
) -> Tuple[lib.transforms.BaseTransformPandas, Sequence[Any], Mapping[str, Any]]:
    r"""
    Prepare transformation.

    Args
    ----
    - name
        Transformation name.
    - prefix
        Cache prefix.
    - suffix
        Cache suffix.

    Returns
    -------
    - transform
        A transformation.
    - fit_args
        Positional arguments for parameter fitting.
    - fit_kwargs
        Keyword arguments for parameter fitting.
    """
    # Prepare preprecoessing.
    transform: lib.transforms.BaseTransformPandas
    fit_args: List[Any]
    fit_kwargs: Dict[str, Any]
    if name == "quantile":
        # Quantile normalization.
        transform = lib.transforms.TransformQuantilizePandas(
            cache_prefix=prefix, cache_suffix=suffix, allow_alias=True
        )
        fit_args = []
        fit_kwargs = dict(scikit_learn_init_kwargs=dict(n_quantiles=1_000, random_state=42))
    else:
        # Unsupporting transformation.
        raise NotImplementedError
    return transform, fit_args, fit_kwargs
