# Import external packages.
import boto3  # type: ignore[import-untyped]


def s3_download_file(url: str, path: str, /) -> None:
    r"""
    Download a file from S3.

    Args
    ----
    - url
        S3 URL.
    - path
        Local path.

    Returns
    -------
    """
    # Call S3 cilent to download content.
    s3client = boto3.client("s3")
    assert url.startswith("s3://")
    s3bucket, s3relpath = url[len("s3://") :].split("/", maxsplit=1)
    s3client.download_file(s3bucket, s3relpath, path)
