# Import Python packages.
from typing import TypeVar

# Import external packages.
import pandas as pd

# Import relatively from other modules.
from .memory import BaseTransformList


# Self types.
SelfBaseTransformPandas = TypeVar("SelfBaseTransformPandas", bound="BaseTransformPandas")


class BaseTransformPandas(BaseTransformList[pd.DataFrame, pd.DataFrame]):
    r"""
    Base of transformation for Pandas-only memory containers.
    """
    # Transformation unique identifier.
    _IDENTIFIER = "_pandas"
