# Import Python packages.
from typing import Any, List, TypeVar

# Import relatively from other modules.
from ..base import BaseTransformList


# Type variables.
Slot = TypeVar("Slot")


# Type aliases.
Input = List[Slot]
Output = List[Slot]


# Self types.
SelfTransformCategoryEncode = TypeVar(
    "SelfTransformCategoryEncode", bound="TransformCategoryEncode[Any]"
)


class TransformCategoryEncode(BaseTransformList[Slot, Slot]):
    r"""
    Transformation for category encoding.
    """
    # Transformation unique identifier.
    _IDENTIFIER = "cateenc._base"

    def transform_(
        self: SelfTransformCategoryEncode, input: Input[Slot], /, *args: Any, **kwargs: Any
    ) -> SelfTransformCategoryEncode:
        r"""
        Transform input with inplacement.

        Args
        ----
        - input
            Input to the transformation.

        Returns
        -------
        - self
            Class instance itself.
        """
        # Get the output and replace input of corresponding positions by the output.
        output = self.transform(input, *args, **kwargs)
        features_categorical, features_continuous, labels_categorical, labels_continuous = output
        input[0], input[1], input[2], input[3] = (
            features_categorical,
            features_continuous,
            labels_categorical,
            labels_continuous,
        )
        return self

    def inverse_(
        self: SelfTransformCategoryEncode, output: Output[Slot], /, *args: Any, **kwargs: Any
    ) -> SelfTransformCategoryEncode:
        r"""
        Inverse output with inplacement.

        Args
        ----
        - output
            Output from the transformation.

        Returns
        -------
        - self
            Class instance itself.
        """
        # Get the input and replace output of corresponding positions by the input.
        input = self.inverse(output, *args, **kwargs)
        features_categorical, features_continuous, labels_categorical, labels_continuous = input
        output[0], output[1], output[2], output[3] = (
            features_categorical,
            features_continuous,
            labels_categorical,
            labels_continuous,
        )
        return self
