# Import Python packages.
import os

# Import PyTest packagtes.
import pytest

# Import PyTest external packages.
from py._path.local import LocalPath

# Import testing library.
from .supp_base import DataInts, DataNull


def test_null() -> None:
    r"""
    Test data container of nothing.

    Args
    ----

    Returns
    -------
    """
    # Test data container tags.
    data = DataNull(None)
    tags = data.tags
    assert not tags.emptiable
    assert tags.ambiguous


@pytest.mark.parametrize(
    "allow_alias", [pytest.param(True, id="alias"), pytest.param(False, id="copy")]
)
def test_ints(*, tmpdir: LocalPath, allow_alias: bool) -> None:
    r"""
    Test data container of integers.

    Args
    ----
    - tmpdir
        Temporary directory for this test.
        It is automatically provided by PyTest, so its value should not be explicitly defined.
    - allow_alias
        If True, the content of data container is an alias of source content.
        If False, the content of data container is a completed copy of source content.

    Returns
    -------
    """
    # Test data container tags.
    root = str(tmpdir)
    source = [1, 2, 3]
    data = DataInts(source, allow_alias_disambiguition=allow_alias)
    tags = data.tags
    assert tags.emptiable
    assert not tags.ambiguous

    # Identity content of list container should be empty list.
    identity = data.identity()
    assert not identity._content

    # Modify source content, and compare with saved content of container.
    path = os.path.join(root, "data.json")
    source.insert(0, 0)
    data.save(path)
    data.load(path)
    assert len(data._content) + int(not allow_alias) == len(source)
