# Import PyTest packages.
import pytest

# Import developing library.
import fin_tech_py_toolkit as lib


@pytest.mark.parametrize(
    "negate",
    [pytest.param(negate, id="negative" if negate else "positive") for negate in [True, False]],
)
def test_default(*, negate: bool) -> None:
    r"""
    Test regular waiting.

    Args
    ----
    - negate
        If True, test negating indication.

    Returns
    -------
    """
    # Indication is made according to negating flag.
    lib.time.wait_until_true(lambda: not negate, negate=negate, timeout=1e-3, interval=1e-4)


@pytest.mark.xfail(raises=TimeoutError)
def test_timeout() -> None:
    r"""
    Test timeout error of waiting.

    Args
    ----

    Returns
    -------
    """
    # Wait forever unitl timeout.
    lib.time.wait_until_true(lambda: False, timeout=1e-3, interval=1e-4)
