# Import Python packages.
import os
from typing import Any

# Import PyTest packages.
import pytest

# Import PyTest external packages.
from py._path.local import LocalPath

# Import developing library.
import fin_tech_py_toolkit as lib

# Import testing library.
from ...data.supp_base import DataInts
from ...datasets.supp_base import DatasetInts
from .supp_base import TransdatasetSplitInts


@pytest.mark.parametrize(
    ("raw_input", "raw_output"),
    [pytest.param(..., None, id="input"), pytest.param(None, ..., id="output")],
)
@pytest.mark.xfail(raises=lib.transforms.ErrorTransformUnsupportPartial)
def test_io_unsupport(*, raw_input: Any, raw_output: Any) -> None:
    r"""
    Test dataset unravel transformation input and output domain formalization with unsupported raw
    data.

    Args
    ----
    - raw_input
        Raw input.
    - raw_output
        Raw output.

    Returns
    -------
    """
    # Simply formalize input and output, and expect unsupporting error.
    transform = TransdatasetSplitInts()
    transform.input(raw_input)
    transform.output(raw_output)


def test_ints(*, tmpdir: LocalPath) -> None:
    r"""
    Test dataset unravel transformation for integer dataset.

    Args
    ----
    - tmpdir
        Temporary directory for this test.
        It is automatically provided by PyTest, so its value should not be explicitly defined.

    Returns
    -------
    """
    # Test transformation tags.
    root = str(tmpdir)
    transform = TransdatasetSplitInts()
    tags = transform.tags
    assert not tags.inplacable
    assert not tags.invertible
    assert not tags.parametric
    assert not tags.hierarchy

    # Create dataset source files.
    source = [1, 2, 3]
    dataset = DatasetInts.from_memalias([DataInts(source)], ["source"])
    source_head = [1, 2]
    source_tail = [3]
    dataset_head = DatasetInts.from_memalias([DataInts(source_head)], ["source"])
    dataset_tail = DatasetInts.from_memalias([DataInts(source_tail)], ["source"])
    input = [dataset]

    # Test regular usage functions.
    transform.save(os.path.join(root, "split_dataset_ints"))
    transform.load(os.path.join(root, "split_dataset_ints"))

    # Test non-trivial usage functions.
    dataset_head_, dataset_tail_ = transform.transform(input, props=[(["source"], (1, 1))])
    assert all(
        tuple(data._content) == tuple(data_._content)
        for data, data_ in zip(dataset_head.memory, dataset_head_.memory)
    )
    assert all(
        tuple(data._content) == tuple(data_._content)
        for data, data_ in zip(dataset_tail.memory, dataset_tail_.memory)
    )
