## Experiment Reproduce

To reprodeuce all experiments, you need to first install source code package to your Python environment (>= 3.8).
In current directory (where this `README.md` stays), run PyPI installation:
```
pip install -r requirements.txt
pip install -e .
```

After installation, you can reproduce all zero-shot transfer, supervised and unsupervised learning experiments.
We use *adult* (which can be replaced by other names) dataset as the example, and you can find all dataset definitions under `exp/data`.
To get raw data corresponding to each definition, please download from the URL in the dataset table of our paper.
- Zero-shot Transfer Learning
  ```
  cd exp/transfer
  python transfer.py adult
  cd ..
  ```
- Supervised Learning
  ```
  cd exp/supervised
  python supervised.py adult
  cd ..
  ```
- Unsupervised Learning
  ```
  cd exp/unsupervised
  python unsupervised.py adult
  cd ..
  ```