# Import Python packages.
from typing import Any, TypeVar

# Import relatively from other modules.
from .base import _REGISTRATIONS, BaseData


# Self types.
SelfFactoryData = TypeVar("SelfFactoryData", bound="FactoryData")


class FactoryData(object):
    r"""
    Factory producing data containers.
    """

    def from_args(
        self: SelfFactoryData, identifier: str, content: Any, /, *args: Any, **kwargs: Any
    ) -> BaseData[Any]:
        r"""
        Create a data container directly from argumnets.

        Args
        ----
        - identifier
            Identifier of the data container.
        - content
            Content of the data container.

        Returns
        -------
        - data
            A data container.
        """
        # Get the data container class from registry.
        assert (
            identifier in _REGISTRATIONS
        ), f'Unregistered data container identifier: "{identifier:s}".'
        cls = _REGISTRATIONS[identifier]

        # Create an instance based on arguments.
        return cls(content, *args, **kwargs)
