# Import Python packages.
import time
from typing import Any, Callable, Optional


# Constants.
TIMEOUT = 1.0
INTERVAL = 0.1


def wait_until_true(
    f: Callable[..., bool],
    /,
    *args: Any,
    negate: bool = False,
    timeout: Optional[float] = None,
    interval: Optional[float] = None,
    **kwargs: Any,
) -> None:
    """
    Wait until the function returns True.

    Args
    ----
    - f
        The indicator function to call every interval.
    - negate
        Negative flag returned by the indicator function.
    - timeout
        Maximum seconds to wait before raising timeout error.
    - interval
        The interval in seconds to call indicator function.

    Returns
    -------
    """
    # Fill default values.
    global TIMEOUT, INTERVAL
    timeout_ = TIMEOUT if timeout is None else timeout
    interval_ = INTERVAL if interval is None else interval

    # Periodically call indicator function until run out of time and raise timeout error.
    start_time = time.time()
    while f(*args, **kwargs) if negate else not f(*args, **kwargs):
        # Hang idle for given interval before next call.
        time.sleep(interval_)
        end_time = time.time()
        elapsed = end_time - start_time
        if elapsed > timeout_:
            # On timeout error, report elapsed time.
            raise TimeoutError(f"Timeout after {elapsed:.3f} seconds.")
