# Import Python packages.
from typing import Any, List, TypeVar

# Import relatively from other modules.
from .base import BaseTransform


# Type variables.
Input = TypeVar("Input")
Output = TypeVar("Output")


# Self types.
SelfBaseTransformList = TypeVar("SelfBaseTransformList", bound="BaseTransformList[Any, Any]")


class BaseTransformList(BaseTransform[List[Input], List[Output]]):
    r"""
    Base of transformation within memory containers.
    """
    # Transformation unique identifier.
    _IDENTIFIER = "_memory"

    def __init__(self: SelfBaseTransformList, /, *args: Any, **kwargs: Any) -> None:
        r"""
        Initialize the class.

        Args
        ----

        Returns
        -------
        """
        # Super call.
        BaseTransform.__init__(self, *args, **kwargs)
