# Import Python packages.
from typing import Any, Mapping, TypeVar

# Import relatively from other modules.
from ..types import NPANYS
from .base import BaseTransform


# Self types.
SelfTransformIdentity = TypeVar("SelfTransformIdentity", bound="TransformIdentity")


class TransformIdentity(BaseTransform[Any, Any]):
    r"""
    Transformation for identity.
    """
    # Transformation unique identifier.
    _IDENTIFIER = "identity"

    def input(self: SelfTransformIdentity, raw: Any, /) -> Any:
        r"""
        Convert raw data into input to the transformation.

        Args
        ----
        - raw
            Raw data.

        Returns
        -------
        - process
            Processed data compatible with the transformation.
        """
        # Do nothing.
        return raw

    def output(self: SelfTransformIdentity, raw: Any, /) -> Any:
        r"""
        Convert raw data into output from the transformation.

        Args
        ----
        - raw
            Raw data.

        Returns
        -------
        - process
            Processed data compatible with the transformation.
        """
        # Do nothing.
        return raw

    def transform(self: SelfTransformIdentity, input: Any, /, *args: Any, **kwargs: Any) -> Any:
        r"""
        Transform input into output without inplacement.

        Args
        ----
        - input
            Input to the transformation.

        Returns
        -------
        - output
            Output from the transformation.
        """
        # Do nothing.
        return input

    def transform_(
        self: SelfTransformIdentity, input: Any, /, *args: Any, **kwargs: Any
    ) -> SelfTransformIdentity:
        r"""
        Transform input with inplacement.

        Args
        ----
        - input
            Input to the transformation.

        Returns
        -------
        - self
            Class instance itself.
        """
        # Do nothing.
        return self

    def inverse(self: SelfTransformIdentity, output: Any, /, *args: Any, **kwargs: Any) -> Any:
        r"""
        Inverse output back into input without inplacement.

        Args
        ----
        - output
            Output from the transformation.

        Returns
        -------
        - input
            Input to the transformation.
        """
        # Do nothing.
        return output

    def inverse_(
        self: SelfTransformIdentity, output: Any, /, *args: Any, **kwargs: Any
    ) -> SelfTransformIdentity:
        r"""
        Inverse output back with inplacement.

        Args
        ----
        - output
            Output from the transformation.

        Returns
        -------
        - self
            Class instance itself.
        """
        # Do nothing.
        return self

    def get_metadata(self: SelfTransformIdentity, /) -> Mapping[str, Any]:
        r"""
        Get metadata of the transformation.

        Args
        ----

        Returns
        -------
        - metadata
            Metadata of the transformation.
        """
        # No metadata is defined.
        return {}

    def get_numeric_data(self: SelfTransformIdentity, /) -> Mapping[str, NPANYS]:
        r"""
        Get numeric data of the transformation.

        Args
        ----

        Returns
        -------
        - data
            Numeric data of the transformation.
        """
        # No numeric data is defined.
        return {}

    def get_alphabetic_data(self: SelfTransformIdentity, /) -> Mapping[str, Any]:
        r"""
        Get alphabetic data of the transformation.

        Args
        ----

        Returns
        -------
        - data
            Alphabetic data of the transformation.
        """
        # No alphabetic data is defined.
        return {}

    def set_metadata(
        self: SelfTransformIdentity, metadata: Mapping[str, Any], /  # noqa: W504
    ) -> SelfTransformIdentity:
        r"""
        Set metadata of the transformation.

        Args
        ----
        - metadata
            Metadata of the transformation.

        Returns
        -------
        - self
            Class instance itself.
        """
        # Do nothing.
        return self

    def set_numeric_data(
        self: SelfTransformIdentity, data: Mapping[str, NPANYS], /  # noqa: W504
    ) -> SelfTransformIdentity:
        r"""
        Set numeric data of the transformation.

        Args
        ----
        - data
            Numeric data of the transformation.

        Returns
        -------
        - self
            Class instance itself.
        """
        # Do nothing.
        return self

    def set_alphabetic_data(
        self: SelfTransformIdentity, data: Mapping[str, Any], /  # noqa: W504
    ) -> SelfTransformIdentity:
        r"""
        Set alphabetic data of the transformation.

        Args
        ----
        - data
            Alphabetic data of the transformation.

        Returns
        -------
        - self
            Class instance itself.
        """
        # Do nothing.
        return self
