# Import Python packages.
from typing import Union

# Import external packages.
import numpy as np
import numpy.typing as npt


# Boolean type aliases.
NPBOOLS = npt.NDArray[np.bool_]


# Integer type aliases.
NPINT16S = npt.NDArray[np.int16]
NPINT32S = npt.NDArray[np.int32]
NPINT64S = npt.NDArray[np.int64]
NPINTS = Union[NPINT16S, NPINT32S, NPINT64S]


# Floating type aliases.
NPFLOAT16S = npt.NDArray[np.float16]
NPFLOAT32S = npt.NDArray[np.float32]
NPFLOAT64S = npt.NDArray[np.float64]
NPFLOATS = Union[NPFLOAT16S, NPFLOAT32S, NPFLOAT64S]


# Byte string type aliases.
NPBYTES = npt.NDArray[np.bytes_]


# Character string type aliases.
NPCHARS = npt.NDArray[np.str_]


# Mixed type aliases.
NPNUMS = Union[NPINTS, NPFLOATS]
NPANYS = Union[NPBOOLS, NPNUMS, NPBYTES, NPCHARS]
