# Import Python packages.
import os
from typing import Any

# Import PyTest packages.
import pytest

# Import PyTest external packages.
from py._path.local import LocalPath

# Import developing library.
import fin_tech_py_toolkit as lib

# Import testing library.
from ...data.supp_base import DataInts
from ...datasets.supp_base import DatasetInts
from .supp_base import TransdatasetUnravelInts


@pytest.mark.parametrize(
    ("raw_input", "raw_output"),
    [pytest.param(..., None, id="input"), pytest.param(None, ..., id="output")],
)
@pytest.mark.xfail(raises=lib.transforms.ErrorTransformUnsupportPartial)
def test_io_unsupport(*, raw_input: Any, raw_output: Any) -> None:
    r"""
    Test dataset unravel transformation input and output domain formalization with unsupported raw
    data.

    Args
    ----
    - raw_input
        Raw input.
    - raw_output
        Raw output.

    Returns
    -------
    """
    # Simply formalize input and output, and expect unsupporting error.
    transform = TransdatasetUnravelInts()
    transform.input(raw_input)
    transform.output(raw_output)


def test_ints(*, tmpdir: LocalPath) -> None:
    r"""
    Test dataset unravel transformation for integer dataset.

    Args
    ----
    - tmpdir
        Temporary directory for this test.
        It is automatically provided by PyTest, so its value should not be explicitly defined.

    Returns
    -------
    """
    # Test transformation tags.
    root = str(tmpdir)
    transform = TransdatasetUnravelInts()
    tags = transform.tags
    assert not tags.inplacable
    assert not tags.invertible
    assert not tags.parametric
    assert not tags.hierarchy

    # Create dataset source files.
    source = [1, 2, 3]
    dataset = DatasetInts.from_memalias([DataInts(source)], ["source"])
    input = [dataset]

    # Test regular usage functions.
    transform.save(os.path.join(root, "unravel_dataset_ints"))
    transform.load(os.path.join(root, "unravel_dataset_ints"))

    # Test non-trivial usage functions.
    input = [dataset]
    (array,) = transform.transform(input)
    assert tuple(array) == tuple(source)
