# TIL
Trajectory Independent Learning 

## Installation
* Create a new conda environment and activate it:
```
conda create -n til python=3.7
conda activate til
```

* Install PyTorch, following instructions in `https://pytorch.org`. The released experiments were run with CUDA 10.2

* Install spaghettini.
```
pip install spaghettini
```

* Navigate to the root of the project. Install the package, along with requirements:
```
pip install --editable ./
```

## Running single experiments:
* Locate the directory that contains a ```template.yaml``` config file, and use the following commands to launch the experiments:
```
EXP_DIR='runs/dev/sample_experiments/001_unroll_bp'
python -um src.mains.run --cfg ${EXP_DIR}/template.yaml --tmp_ckpt_dir_abs ${EXP_DIR} --job_names "train"
```

## Running experiments reported in the paper.
We're releasing the full hyperparameter sweeps we did for the sake of transparency. The experiment configuration files 
that contain these sweeps are meant to be run in parallel on a compute cluster. Below, we describe how one can extract 
single runnable experiments from these sweeps. 

* Step 1: Locate the experiment directory you'd like to replicate under ```runs/dev/neurips```. 
* Step 2: Located th ```template.yaml``` config file underneath. This contains the experimental configuration, as the well 
hyperparameter sweeps.
* Step 3: The pipe (```|```) syntax refers to the sweeps contained in the experiment. Pick the configuration you'd like to 
replicate, and remove the unwanted configurations. (i.e if you'd like to remove the configuration represented by ```xxx|yyy: ...```, simply remove the ```|yyy``` to obtain ```xxx: ...```)
* Step 4: The updated config files can now be run as single experiments as described above. 