import argparse

from spaghettini import load


if __name__ == "__main__":
    """
    Sample command: (run from root)
    python -um src.mains.run --cfg "cfg_yaml" --tmp_ckpt_dir_abs "ckpt_path" --job_names "train" "test"
    """
    print("Run initiated. ")
    # ____ Parse the args, get the config. ____
    parser = argparse.ArgumentParser()
    parser.add_argument("--cfg", type=str,
                        help="The (relative) path to the configuration file. ")
    parser.add_argument("--tmp_ckpt_dir_abs", type=str,
                        help="The (absolute) path to the temporary checkpoint directory. ")
    parser.add_argument("--job_names", nargs="+",
                        help="A list of job names to run sequentially.",
                        default="train")

    args = parser.parse_args()

    # ____ Load the config. ____
    cfg, exp_name = load(args.cfg, gather_hparams=False, verbose=False, record_config=False)

    # ____ Perform task. ____
    for job_name in args.job_names:
        cfg.task_fns[job_name](cfg, exp_name=exp_name, cfg_dir=args.cfg, tmp_dir=args.tmp_ckpt_dir_abs)
